<?php
// /funworld/tools/self_check.php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';

function ok($b){ return $b ? '✅' : '❌'; }
function card($t,$b=true,$m=''){
  echo '<div style="background:#151A22;border:1px solid #222;border-radius:12px;padding:12px;margin:10px 0">
  <div><strong>'.$t.'</strong> '.ok($b).'</div>'.($m?'<div style="color:#9aa4b2;margin-top:6px">'.$m.'</div>':'').'</div>';
}
header('Content-Type: text/html; charset=utf-8');
echo '<div style="max-width:980px;margin:20px auto;font-family:system-ui,Segoe UI,Tahoma;color:#e5e7eb">';

echo '<h2 style="margin:0 0 14px">Fun World — Self Check</h2>';

/* ---------- PHP/Extensions ---------- */
$exts = [
  'curl' => function_exists('curl_init'),
  'json' => function_exists('json_encode'),
  'mbstring' => function_exists('mb_strlen'),
  'openssl' => function_exists('openssl_random_pseudo_bytes'),
];
$phpok = PHP_VERSION_ID >= 70400;
card('PHP >= 7.4', $phpok, 'Current: '.PHP_VERSION);
foreach($exts as $k=>$v) card('ext: '.$k, $v);

/* ---------- Base URL / Steam callback ---------- */
$base = defined('FW_BASE_URL') ? FW_BASE_URL : null;
$base_ok = $base && !preg_match('~/+$~',$base); // بدون / آخر
$cb = $base_ok ? $base.'/actions/steam_callback.php' : '(base not set)';
card('FW_BASE_URL', $base_ok, 'FW_BASE_URL='.htmlspecialchars((string)$base));
card('Steam Callback URL', $base_ok, htmlspecialchars($cb));

/* ---------- Writable dirs ---------- */
$w1 = is_writable(__DIR__.'/../assets/img');
card('assets/img writable', $w1);
$w2 = is_writable(__DIR__.'/../logs') || @mkdir(__DIR__.'/../logs',0775,true);
card('/logs exists/writable (اختیاری)', $w2);

/* ---------- DB & schema ---------- */
try{$pdo = db(); $pdo->query('SELECT 1')->fetchColumn(); $dbok=true;}catch(Throwable $e){ $dbok=false; $dbmsg=$e->getMessage(); }
card('Database connection', $dbok, isset($dbmsg)?$dbmsg:'');

$need = [
  'users' => ['id','steam_id64','name','avatar_url','role','elo','calibration_left','is_18_confirmed'],
  'teams' => ['id','name','tag','captain_id','elo','calibration_left','logo_url'],
  'team_members' => ['id','team_id','user_id','slot'],
  'servers' => ['id','name','ip_port','password','rcon','tournament_id'],
  'tournaments' => ['id','title','entry_fee','status','max_teams','ruleset','map_pool','schedule_start','logo_url'],
  'tournament_teams' => ['id','tournament_id','team_id','paid','seed'],
  'matches' => ['id','tournament_id','team_a_id','team_b_id','status','score_a','score_b','start_at','finished_at','server_id','knife_winner','stream_url'],
  'match_maps' => ['id','match_id','map_order','map_name','picked_by'],
  'match_ready' => ['id','match_id','user_id','ready','updated_at'],
  'match_chat' => ['id','match_id','user_id','msg','created_at'],
  'wallets' => ['id','owner_type','owner_id','balance'],
  'transactions' => ['id','wallet_owner_type','wallet_owner_id','direction','amount','ref_type','ref_id','created_at'],
  'payments' => ['id','user_id','provider','amount','currency','status','created_at'],
  'invites' => ['id','team_id','token','role','expires_at','used_at','created_by'],
  'predictions' => ['id','match_id','user_id','side','amount','status','payout'],
  'settings' => ['key','value'],
  'audit_logs' => ['id','actor_id','action','ref_type','ref_id','created_at'],
  'seasons' => ['id','name','start_date','end_date','is_active'],
  'season_ratings' => ['id','season_id','team_id','elo','calibration_left'],
  'disputes' => ['id','match_id','team_id','user_id','subject','status','created_at'],
  'dispute_messages' => ['id','dispute_id','user_id','role','body','created_at'],
  'rcon_logs' => ['id','match_id','server_id','cmd','result','actor_id','created_at'],
];

if($dbok){
  foreach($need as $tbl=>$cols){
    try{
      $has = $pdo->prepare("SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=?");
      $has->execute([$tbl]); $existing = array_map('strtolower',$has->fetchAll(PDO::FETCH_COLUMN));
      $missing = array_values(array_diff(array_map('strtolower',$cols), $existing));
      card("table: $tbl", empty($missing), empty($missing)?'OK':'Missing: '.implode(', ',$missing));
    }catch(Throwable $e){
      card("table: $tbl", false, 'Error: '.$e->getMessage());
    }
  }
}

/* ---------- Orphan / FK sanity ---------- */
try{
  $bad = [];
  $bad['matches_team_a'] = $pdo->query("SELECT COUNT(*) FROM matches m LEFT JOIN teams t ON t.id=m.team_a_id WHERE m.team_a_id IS NOT NULL AND t.id IS NULL")->fetchColumn();
  $bad['matches_team_b'] = $pdo->query("SELECT COUNT(*) FROM matches m LEFT JOIN teams t ON t.id=m.team_b_id WHERE m.team_b_id IS NOT NULL AND t.id IS NULL")->fetchColumn();
  $bad['tt_team']        = $pdo->query("SELECT COUNT(*) FROM tournament_teams tt LEFT JOIN teams t ON t.id=tt.team_id WHERE t.id IS NULL")->fetchColumn();
  $bad['tt_tour']        = $pdo->query("SELECT COUNT(*) FROM tournament_teams tt LEFT JOIN tournaments tr ON tr.id=tt.tournament_id WHERE tr.id IS NULL")->fetchColumn();
  $msg = [];
  foreach($bad as $k=>$v){ if($v>0) $msg[]="$k: $v"; }
  card('FK sanity (orphan rows)', empty($msg), $msg?implode(' | ',$msg):'OK');
}catch(Throwable $e){ card('FK sanity', false, $e->getMessage()); }

/* ---------- Routes / files ---------- */
$mustFiles = [
  '/pages/match_lobby.php','/pages/match_view.php','/pages/tournaments.php',
  '/pages/tournament_view.php','/pages/team_manage.php','/actions/ready_toggle.php',
  '/actions/map_pick_action.php','/actions/predict_place.php','/pages/xhr_match_chat.php',
];
$miss = [];
foreach($mustFiles as $f){ if(!file_exists(__DIR__.'/..'.$f)) $miss[]=$f; }
card('Required files', empty($miss), $miss?('Missing: '.implode(', ',$miss)):'OK');

echo '<div style="opacity:.7;margin-top:8px" class="small">* اگر چیزی قرمز شد، اسکرین همین صفحه رو برام بفرست.</div>';
echo '</div>';
