-- users
CREATE TABLE IF NOT EXISTS users (
id INT AUTO_INCREMENT PRIMARY KEY,
steam_id64 VARCHAR(32) UNIQUE,
name VARCHAR(100),
avatar_url VARCHAR(255),
email VARCHAR(120),
role ENUM('admin','moderator','captain','player','banned') DEFAULT 'player',
elo INT DEFAULT 1000,
kd DECIMAL(4,2) DEFAULT 1.00,
hs DECIMAL(5,2) DEFAULT 50.00,
country VARCHAR(64),
banned_at DATETIME NULL,
created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- teams
CREATE TABLE IF NOT EXISTS teams (
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(100) NOT NULL,
tag VARCHAR(6),
logo_url VARCHAR(255),
captain_id INT NOT NULL,
elo INT DEFAULT 1000,
bio TEXT,
created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
FOREIGN KEY (captain_id) REFERENCES users(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- team_members
CREATE TABLE IF NOT EXISTS team_members (
id INT AUTO_INCREMENT PRIMARY KEY,
team_id INT NOT NULL,
user_id INT NOT NULL,
slot ENUM('starter','sub') DEFAULT 'starter',
created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
UNIQUE KEY uniq_member (team_id,user_id),
FOREIGN KEY (team_id) REFERENCES teams(id) ON DELETE CASCADE,
FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- tournaments
CREATE TABLE IF NOT EXISTS tournaments (
id INT AUTO_INCREMENT PRIMARY KEY,
title VARCHAR(150) NOT NULL,
entry_fee INT DEFAULT 20000, -- تومان
status ENUM('draft','open','running','finished') DEFAULT 'draft',
max_teams INT DEFAULT 16,
ruleset JSON NULL,
map_pool JSON NULL,
schedule_start DATETIME NULL,
schedule_lock_at DATETIME NULL,
created_at DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- tournament_teams
CREATE TABLE IF NOT EXISTS tournament_teams (
id INT AUTO_INCREMENT PRIMARY KEY,
tournament_id INT NOT NULL,
team_id INT NOT NULL,
seed INT NULL,
paid TINYINT(1) DEFAULT 0,
checkin_at DATETIME NULL,
UNIQUE KEY uniq_tt (tournament_id,team_id),
FOREIGN KEY (tournament_id) REFERENCES tournaments(id) ON DELETE CASCADE,
FOREIGN KEY (team_id) REFERENCES teams(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- servers
CREATE TABLE IF NOT EXISTS servers (
id INT AUTO_INCREMENT PRIMARY KEY,
name VARCHAR(100) NOT NULL,
ip_port VARCHAR(50) NOT NULL,
password VARCHAR(100) NULL,
rcon VARCHAR(100) NULL,
notes TEXT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


-- matches
CREATE TABLE IF NOT EXISTS matches (
id INT AUTO_INCREMENT PRIMARY KEY,
tournament_id INT NOT NULL,
round INT NOT NULL,
team_a_id INT NULL,
team_b_id INT NULL,
start_at DATETIME NULL,
server_id INT NULL,
stream_url VARCHAR(255) NULL,
status ENUM('scheduled','live','done') DEFAULT 'scheduled',
result ENUM('A','B') NULL,
score_a TINYINT NULL,
score_b TINYINT NULL,
knife_winner ENUM('A','B') NULL, -- برای منطق انتخاب مپ
created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
FOREIGN KEY (tournament_id) REFERENCES tournaments(id) ON DELETE CASCADE,
FOREIGN KEY (team_a_id) REFERENCES teams(id),
FOREIGN KEY (team_b_id) REFERENCES teams(id),
FOREIGN KEY (server_id) REFERENCES servers(id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;