<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$page_title = 'ایجاد تورنمنت';
include __DIR__.'/_layout_header.php';
?>
<!-- استایل کوچک برای پیش‌نمایش لوگو -->
<style>
  .preview{display:flex;align-items:center;gap:10px;margin:6px 0}
  .preview img{width:60px;height:60px;border-radius:10px;object-fit:cover;border:1px solid #222}
</style>

<div class="card">
  <form id="tForm" method="post" action="<?=base_url('actions/tournament_create_action.php')?>" enctype="multipart/form-data">
    <label>عنوان</label>
    <input name="title" required>

    <label>لوگوی تورنمنت (PNG/JPG)</label>
    <input id="logo" type="file" name="logo" accept=".png,.jpg,.jpeg">
    <div class="preview" id="logoPrev" style="display:none">
      <img id="logoImg" alt="logo">
      <div class="small">پیش‌نمایش لوگو</div>
    </div>

    <label>ورودی هر تیم (تومان)</label>
    <input type="number" name="entry_fee" min="0" value="20000">

    <label>حداکثر تیم (اختیاری، می‌تونیم بیشتر هم راه بدیم)</label>
    <input type="number" name="max_teams" min="2" value="16">

    <label>تاریخ/ساعت شروع (شمسی)</label>
    <input id="pdate" type="text" placeholder="انتخاب از تقویم">
    <input type="hidden" name="schedule_start" id="greg">

    <button class="btn" style="margin-top:8px">ذخیره</button>
  </form>

  <p class="small">قوانین پیش‌فرض: MR12، Bo3، Overtime MR3(10k). Map Pool: <?=h(implode(', ',FW_MAP_POOL))?></p>
</div>

<!-- اگر jQuery/تقویم بارگذاری نشده بود، از CDN می‌آوریم -->
<script>
(function ensureDeps(){
  function add(src, cb){ var s=document.createElement('script'); s.src=src; s.onload=cb; document.head.appendChild(s); }
  function addCss(href){ var l=document.createElement('link'); l.rel='stylesheet'; l.href=href; document.head.appendChild(l); }

  function init(){
    // persianDatepicker راه‌اندازی
    try{
      $('#pdate').pDatepicker({
        timePicker: { enabled: true },
        altField: '#greg',
        altFormat: 'YYYY-MM-DD HH:mm:ss',
        altFieldFormatter: function(unix){
          return new persianDate(unix).toCalendar('gregorian').format('YYYY-MM-DD HH:mm:ss');
        }
      });
    }catch(e){
      console.warn('Persian datepicker not available', e);
    }

    // ولیدیشن ساده و پیش‌نمایش لوگو
    const $form = document.getElementById('tForm');
    const $logo = document.getElementById('logo');
    const $prev = document.getElementById('logoPrev');
    const $img  = document.getElementById('logoImg');

    $logo?.addEventListener('change', function(){
      const f = this.files && this.files[0];
      if(!f) { $prev.style.display='none'; return; }
      const okType = ['image/png','image/jpeg'].includes(f.type);
      const okSize = f.size <= 2*1024*1024; // <= 2MB
      if(!okType){ alert('فقط PNG یا JPG مجاز است'); this.value=''; $prev.style.display='none'; return; }
      if(!okSize){ alert('حداکثر اندازه لوگو: ۲ مگابایت'); this.value=''; $prev.style.display='none'; return; }
      const url = URL.createObjectURL(f);
      $img.src = url; $prev.style.display='flex';
    });

    $form?.addEventListener('submit', function(e){
      const g = document.getElementById('greg').value;
      if(!g){ e.preventDefault(); alert('تاریخ/ساعت را انتخاب کنید'); return false; }
    });
  }

  // اگر jQuery نیست، بارگذاری شود
  if(typeof window.jQuery === 'undefined'){
    add('https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js', function(){
      // CSS/JS تقویم
      addCss('https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css');
      add('https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.js', function(){
        add('https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.js', init);
      });
    });
  }else{
    // jQuery هست؛ فقط تقویم را اضافه می‌کنیم (اگر نبود)
    if(typeof window.persianDate === 'undefined'){
      addCss('https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/css/persian-datepicker.min.css');
      add('https://cdn.jsdelivr.net/npm/persian-date@1.1.0/dist/persian-date.js', function(){
        add('https://cdn.jsdelivr.net/npm/persian-datepicker@1.2.0/dist/js/persian-datepicker.js', init);
      });
    }else{
      init();
    }
  }
})();
</script>
<script>
function fa2en(s){
  return s
    .replace(/[۰-۹]/g, ch => '0123456789'['۰۱۲۳۴۵۶۷۸۹'.indexOf(ch)])
    .replace(/[٠-٩]/g, ch => '0123456789'['٠١٢٣٤٥٦٧٨٩'.indexOf(ch)]);
}

$(function(){
  $('#pdate').pDatepicker({
    timePicker: { enabled: true },
    altField: '#greg',
    altFormat: 'YYYY-MM-DD HH:mm:ss',
    altFieldFormatter: function(unix){
      var s = new persianDate(unix).toCalendar('gregorian').format('YYYY-MM-DD HH:mm:ss');
      return fa2en(s); // ← اعداد انگلیسی
    }
  });
  $('#tForm').on('submit', function(){
    if(!$('#greg').val()){ alert('تاریخ/ساعت را انتخاب کنید'); return false; }
  });
});
</script>


<?php include __DIR__.'/_layout_footer.php';
