<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

$U = auth_user(); // برای تشخیص کاپیتان/ادمین
$page_title = 'تیم‌ها';
include __DIR__.'/_layout_header.php';

$pdo = db();
$teams = $pdo->query("
  SELECT t.*, u.name AS captain_name, u.avatar_url AS captain_avatar
  FROM teams t
  LEFT JOIN users u ON u.id = t.captain_id
  ORDER BY t.id DESC
  LIMIT 100
")->fetchAll();
?>

<div class="card">
  <a class="btn alt" href="<?=base_url('pages/team_create.php')?>">ساخت تیم</a>
</div>

<div class="grid cols-3">
<?php foreach ($teams as $t) { list($badge,$badgeImg)=fw_badge_for_elo((int)$t['elo']); ?>
  <div class="card">
    <div style="display:flex;align-items:center;gap:12px">
      <img src="<?=base_url($t['logo_url'] ?: 'assets/img/logo.png')?>" alt="لوگوی تیم"
           style="width:44px;height:44px;border-radius:50%;object-fit:cover">
      <div>
        <div><strong><?=h($t['name'])?></strong> <span class="badge"><?=h($badge)?></span></div>
        <?php list($badge,$badgeImg)=fw_badge_for_elo((int)$t['elo']); ?>
 <div class="small">
   Elo: <?=h($t['elo'])?>
   <img src="<?=base_url($badgeImg)?>" alt="<?=h($badge)?>" title="<?=h($badge)?>"
        style="width:18px;height:18px;vertical-align:-3px;margin-inline-start:6px">
 </div>
      </div>
    </div>

    <hr>

    <div style="display:flex;align-items:center;gap:8px">
      <img src="<?=h($t['captain_avatar'] ?: 'assets/img/avatar.png')?>" alt="کاپیتان"
           style="width:22px;height:22px;border-radius:50%;object-fit:cover">
      <span class="small">کاپیتان: <?=h($t['captain_name'] ?: '—')?></span>
    </div>

    <div style="margin-top:8px;display:flex;gap:8px;flex-wrap:wrap">
      <a class="btn" href="<?=base_url('pages/team_view.php?id='.$t['id'])?>">مشاهده تیم</a>
      <?php if(($U && $U['id']==$t['captain_id']) || is_admin()){ ?>
        <a class="btn alt" href="<?=base_url('pages/team_manage.php?id='.$t['id'])?>">ویرایش تیم</a>
      <?php } ?>
    </div>
  </div>
<?php } ?>
</div>

<?php include __DIR__.'/_layout_footer.php';
