<?php
require_once __DIR__.'/../helpers.php'; require_once __DIR__.'/../db.php'; require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin'); $pdo=db();
$page_title='مدیریت فصل'; include __DIR__.'/_layout_header.php';

if($_SERVER['REQUEST_METHOD']==='POST'){
  $name=trim($_POST['name']??'Season'); $start=trim($_POST['start_date']??date('Y-m-d'));
  $pdo->prepare("UPDATE seasons SET is_active=0 WHERE is_active=1")->execute();
  $pdo->prepare("INSERT INTO seasons(name,start_date,is_active) VALUES(?,?,1)")->execute([$name,$start]);
  $sid=(int)$pdo->lastInsertId();
  // ایجاد رکورد اولیه برای تمام تیم‌ها
  $teams=$pdo->query("SELECT id FROM teams")->fetchAll(PDO::FETCH_COLUMN);
  $ins=$pdo->prepare("INSERT INTO season_ratings(season_id,team_id,elo,calibration_left) VALUES(?,?,1000,10)");
  foreach($teams as $tid){ $ins->execute([$sid,$tid]); }
  audit('season.create','season',$sid,null,['name'=>$name]);
  echo '<div class="card">فصل جدید فعال شد.</div>';
}

$seasons=$pdo->query("SELECT * FROM seasons ORDER BY id DESC")->fetchAll();
?>
<div class="card">
  <form method="post" class="grid cols-3">
    <div><label>نام فصل</label><input name="name" value="Season <?=date('Y')?>"></div>
    <div><label>تاریخ شروع</label><input name="start_date" value="<?=date('Y-m-d')?>"></div>
    <div style="align-self:end"><button class="btn">شروع فصل جدید</button></div>
  </form>
</div>
<div class="card">
  <h3>فصل‌ها</h3>
  <table class="table"><tr><th>ID</th><th>نام</th><th>شروع</th><th>پایان</th><th>Active</th></tr>
  <?php foreach($seasons as $s){ ?>
    <tr><td><?=$s['id']?></td><td><?=h($s['name'])?></td><td><?=$s['start_date']?></td><td><?=$s['end_date']?></td><td><?=$s['is_active']?'✅':'—'?></td></tr>
  <?php } ?></table>
</div>
<?php include __DIR__.'/_layout_footer.php';
