<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
// require_once __DIR__.'/_debug_on.php';

require_auth(); if(!is_admin()) die('Only admin');
$page_title='متریک‌ها و فانل';
include __DIR__.'/_layout_header.php';

$pdo=db();

function safeCount(PDO $pdo, string $sql){
  try { return (int)$pdo->query($sql)->fetchColumn(); }
  catch(Throwable $e){ return 0; }
}

$total_users   = safeCount($pdo, "SELECT COUNT(*) FROM users");
$total_teams   = safeCount($pdo, "SELECT COUNT(*) FROM teams");
$total_tours   = safeCount($pdo, "SELECT COUNT(*) FROM tournaments");
$total_matches = safeCount($pdo, "SELECT COUNT(*) FROM matches");

$teams_with_captain = safeCount($pdo, "SELECT COUNT(*) FROM teams WHERE captain_id IS NOT NULL");
$registered_slots   = safeCount($pdo, "SELECT COUNT(*) FROM tournament_teams");
$matches_done       = safeCount($pdo, "SELECT COUNT(*) FROM matches WHERE status='done'");

# فعال‌های ۳۰ روز اخیر: اگر ستون updated_at نبود، created_at را امتحان کن؛ اگر نبود صفر.
$col = 'updated_at';
try {
  $hasCol = $pdo->query("SHOW COLUMNS FROM match_ready LIKE 'updated_at'")->fetch();
  if(!$hasCol){
    $hasCol = $pdo->query("SHOW COLUMNS FROM match_ready LIKE 'created_at'")->fetch();
    $col = $hasCol ? 'created_at' : null;
  }
} catch(Throwable $e){ $col=null; }

$active_30d = 0;
if($col){
  $stmt = $pdo->prepare("SELECT COUNT(DISTINCT user_id) FROM match_ready WHERE $col >= DATE_SUB(NOW(), INTERVAL 30 DAY)");
  try { $stmt->execute(); $active_30d=(int)$stmt->fetchColumn(); } catch(Throwable $e){ $active_30d=0; }
}

?>
<div class="grid cols-4">
  <div class="card"><div class="small">کاربران</div><h2><?=$total_users?></h2></div>
  <div class="card"><div class="small">تیم‌ها</div><h2><?=$total_teams?></h2></div>
  <div class="card"><div class="small">تورنمنت‌ها</div><h2><?=$total_tours?></h2></div>
  <div class="card"><div class="small">مچ‌ها</div><h2><?=$total_matches?></h2></div>
</div>

<div class="grid cols-3">
  <div class="card"><div class="small">تیم با کپتن</div><h2><?=$teams_with_captain?></h2></div>
  <div class="card"><div class="small">ثبت‌نام در تورنمنت</div><h2><?=$registered_slots?></h2></div>
  <div class="card"><div class="small">مچ‌های تمام‌شده</div><h2><?=$matches_done?></h2></div>
</div>

<div class="card">
  <h3>فعال‌های ۳۰ روز اخیر</h3>
  <p class="small">مبنـا: <?= $col ?: 'نامشخص (ستون تاریخ در match_ready یافت نشد)' ?></p>
  <h2><?=$active_30d?></h2>
</div>

<?php include __DIR__.'/_layout_footer.php';
