<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

require_auth(); if(!is_admin()) die('Only admin');

$tid = (int)($_POST['tid'] ?? 0);
$pairs = $_POST['pair'] ?? [];

if(!$tid || !is_array($pairs) || !$pairs){ die('bad request'); }

$pdo = db();

// اگر قبلاً ساخته شد، برگرد
$have = (int)$pdo->query("SELECT COUNT(*) FROM matches WHERE tournament_id=".$tid)->fetchColumn();
if($have>0){ redirect('pages/tournament_view.php?id='.$tid); }
// گزینهٔ امن برای status از ساختار ستون
$statusInit = 'pending';
try {
    $col = $pdo->query("SHOW COLUMNS FROM matches LIKE 'status'")
               ->fetch(PDO::FETCH_ASSOC);
    if ($col) {
        $type = strtolower($col['Type'] ?? '');
        $def  = $col['Default'] ?? null;

        if ($def !== null && $def !== '') {
            $statusInit = $def;
        }

        if (strpos($type, 'enum(') !== false) {
            preg_match_all("/'([^']+)'/", $type, $m);
            $opts  = $m[1] ?? [];
            $cands = ['pending','scheduled','open','ready','upcoming','created','init'];

            if ($def && in_array($def, $opts, true)) {
                $statusInit = $def;
            } else {
                foreach ($cands as $c) {
                    if (in_array($c, $opts, true)) { $statusInit = $c; break; }
                }
            }

            if ($opts && !in_array($statusInit, $opts, true)) {
                $statusInit = $opts[0];
            }
        }
    }
} catch (\Throwable $e) {
    // silent fallback
}

$used = [];
// جمع‌آوری همه آیتم‌ها برای چک تکرار
foreach($pairs as $i=>$pr){
  $a = (int)($pr['a'] ?? 0);
  $b = (int)($pr['b'] ?? 0);
  if($a>0){ $used[]=$a; }
  if($b>0){ $used[]=$b; }
}
if(count($used)!==count(array_unique($used))){
  die('هر تیم باید فقط یک‌بار استفاده شود.');
}

try{
  $pdo->beginTransaction();

  // آیا ستون round و slot داریم؟
  $cols = $pdo->query("SHOW COLUMNS FROM matches")->fetchAll(PDO::FETCH_COLUMN,0);
  $hasRound = in_array('round',$cols,true);
  $hasSlot  = in_array('slot' ,$cols,true);

  if($hasRound && $hasSlot){
    $ins = $pdo->prepare("INSERT INTO matches(tournament_id,round,slot,team_a_id,team_b_id,status)
                          VALUES(?,?,?,?,?,?)");
  }elseif($hasRound){
    $ins = $pdo->prepare("INSERT INTO matches(tournament_id,round,team_a_id,team_b_id,status)
                          VALUES(?,?,?,?,?)");
  }else{
    $ins = $pdo->prepare("INSERT INTO matches(tournament_id,team_a_id,team_b_id,status)
                          VALUES(?,?,?,?)");
  }

  $slot = 1;
  foreach($pairs as $i=>$pr){
    $a = (int)($pr['a'] ?? 0); if($a===0) $a=null; // 0 = BYE
    $b = (int)($pr['b'] ?? 0); if($b===0) $b=null;

    if($hasRound && $hasSlot){
      $ins->execute([$tid,1,$slot,$a,$b,$statusInit]);
    }elseif($hasRound){
      $ins->execute([$tid,1,$a,$b,$statusInit]);
    }else{
      $ins->execute([$tid,$a,$b,$statusInit]);
    }
    $slot++;
  }

  $pdo->commit();
  redirect('pages/tournament_view.php?id='.$tid);
}catch(Throwable $e){
  $pdo->rollBack();
  http_response_code(500);
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px">';
  echo 'خطا در ذخیره چینش: '.h($e->getMessage());
  echo '</div>';
}
