<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

require_auth();
$U   = auth_user();
$pdo = db();

try {
  $mid = (int)($_POST['match_id'] ?? 0);
  if (!$mid) throw new Exception('bad match id');

  // مچ و تیم‌ها
  $st = $pdo->prepare("SELECT team_a_id, team_b_id FROM matches WHERE id=?");
  $st->execute([$mid]);
  $m = $st->fetch(PDO::FETCH_ASSOC);
  if (!$m) throw new Exception('match not found');

  // عضو یکی از دو تیم؟
  $allowed = false;
  foreach ([(int)$m['team_a_id'], (int)$m['team_b_id']] as $tid) {
    if (!$tid) continue;
    $q = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=? LIMIT 1");
    $q->execute([$tid, (int)$U['id']]);
    if ($q->fetch()) { $allowed = true; break; }
  }
  if (!$allowed && !is_admin()) throw new Exception('not member');

  // مقدار مورد نظر: اگر صریح نیومده، توگل امن انجام بده
  $val = $_POST['ready'] ?? null; // 0/1 یا null
  if ($val === null) {
    $cur = $pdo->prepare("SELECT ready FROM match_ready WHERE match_id=? AND user_id=?");
    $cur->execute([$mid, (int)$U['id']]);
    $curReady = (int)$cur->fetchColumn();
    $val = $curReady ? 0 : 1;
  } else {
    $val = (int)!!$val;
  }

  // آپسرت با یونیک (match_id,user_id)
  $sql = "INSERT INTO match_ready (match_id,user_id,ready,updated_at)
          VALUES (?,?,?,NOW())
          ON DUPLICATE KEY UPDATE ready=VALUES(ready), updated_at=NOW()";
  $pdo->prepare($sql)->execute([$mid, (int)$U['id'], $val]);

  // پاسخ
  $isAjax = (($_POST['ajax'] ?? '')==='1') ||
            (strtolower($_SERVER['HTTP_X_REQUESTED_WITH'] ?? '') === 'xmlhttprequest');
  if ($isAjax) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['ok'=>1,'ready'=>$val]); exit;
  }

  redirect('pages/match_lobby.php?id='.$mid);

} catch (Throwable $e) {
  http_response_code(500);
  $isAjax = (($_POST['ajax'] ?? '')==='1');
  if ($isAjax) {
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode(['ok'=>0,'error'=>$e->getMessage()]); exit;
  }
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px;font-family:system-ui">';
  echo 'خطای Ready: '.h($e->getMessage());
  echo '</div>';
}
$pdo = db();
$mid = (int)($_GET['id'] ?? 0);

// تیم‌ها
$m = $pdo->prepare("SELECT team_a_id, team_b_id FROM matches WHERE id=?");
$m->execute([$mid]);
$mx = $m->fetch(PDO::FETCH_ASSOC);
if (!$mx) { echo json_encode(['ok'=>0]); exit; }

$aId = (int)$mx['team_a_id'];
$bId = (int)$mx['team_b_id'];

// چند نفر آماده هر تیم؟
$qa = $pdo->prepare("SELECT COUNT(*) FROM match_ready mr
  JOIN team_members tm ON tm.user_id=mr.user_id AND tm.team_id=?
  WHERE mr.match_id=? AND mr.ready=1");
$qa->execute([$aId,$mid]); $aReady = (int)$qa->fetchColumn();

$qb = $pdo->prepare("SELECT COUNT(*) FROM match_ready mr
  JOIN team_members tm ON tm.user_id=mr.user_id AND tm.team_id=?
  WHERE mr.match_id=? AND mr.ready=1");
$qb->execute([$bId,$mid]); $bReady = (int)$qb->fetchColumn();

// ظرفیت هدف (۵ نفر یا اندازه واقعی تیم)
$target = 5;

header('Content-Type: application/json; charset=utf-8');
echo json_encode([
  'ok'=>1,
  'a_ready'=>$aReady, 'a_need'=>$target,
  'b_ready'=>$bReady, 'b_need'=>$target,
]);
