<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/rcon.php';
require_auth(); if(!is_admin()) die('Only admin');

$matchId = (int)($_POST['match_id'] ?? 0);
$serverId= (int)($_POST['server_id'] ?? 0);
$cmd     = trim($_POST['cmd'] ?? '');
if(!$serverId || $cmd===''){ redirect('pages/match_view.php?id='.$matchId); }

$pdo = db();
$s = $pdo->prepare("SELECT ip_port, rcon_password FROM servers WHERE id=?");
$s->execute([$serverId]); $sv=$s->fetch(PDO::FETCH_ASSOC);
if(!$sv) die('server not found');

[$host,$port] = explode(':',$sv['ip_port']) + [null,null];
$port = (int)$port;

try{
  $r = new SourceRcon($host,$port,$sv['rcon_password']);
  $out = $r->command($cmd);
  $_SESSION['flash'] = 'RCON OK: '.substr($out,0,300);
}catch(Throwable $e){
  $_SESSION['flash'] = 'RCON ERR: '.$e->getMessage();
}
redirect('pages/match_view.php?id='.$matchId);
