<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');

$pdo = db();
$id  = (int)($_POST['id'] ?? 0);
$step = $_POST['step'] ?? '';

$st = $pdo->prepare("SELECT * FROM matches WHERE id=?");
$st->execute([$id]);
$m = $st->fetch();
if(!$m) die('Match not found');

// Helper: resolve allowed status
function fw_status_pick($pdo,$want){
  $col = $pdo->query("SHOW COLUMNS FROM matches LIKE 'status'")->fetch(PDO::FETCH_ASSOC);
  $type = strtolower($col['Type'] ?? '');
  $def  = $col['Default'] ?? null;
  if (strpos($type,'enum(')!==false) {
    preg_match_all("/'([^']+)'/", $type, $mm); $opts = $mm[1] ?? [];
    if ($want && in_array($want,$opts,true)) return $want;
    foreach (['scheduled','live','done','running','open'] as $c) if (in_array($c,$opts,true)) return $c;
    return $opts[0] ?? $def ?? $want ?? 'scheduled';
  }
  return $want ?: $def ?: 'scheduled';
}

try{
  if($step==='start'){
    $start = fw_parse_datetime($_POST['start_at'] ?? '');
    $server_id = $_POST['server_id']!=='' ? (int)$_POST['server_id'] : null;
    $want = trim($_POST['status'] ?? '');
    $status = fw_status_pick($pdo, $want);

    $sql = "UPDATE matches SET start_at=?, server_id=?, status=? WHERE id=?";
    $pdo->prepare($sql)->execute([$start, $server_id, $status, $id]);
  }

  elseif($step==='knife'){
    $kw = $_POST['knife_winner'] ?? null;
    if($kw!=='A' && $kw!=='B') $kw = null;
    $pdo->prepare("UPDATE matches SET knife_winner=? WHERE id=?")->execute([$kw,$id]);
  }

  elseif($step==='picks'){
    $map_name  = $_POST['map_name'] ?? [];
    $picked_by = $_POST['picked_by'] ?? [];
    // پاک‌سازی قبلی و ساخت سه رکورد
    $pdo->prepare("DELETE FROM match_maps WHERE match_id=?")->execute([$id]);

    $ins = $pdo->prepare("INSERT INTO match_maps(match_id,map_order,map_name,picked_by) VALUES(?,?,?,?)");
    for($i=1;$i<=3;$i++){
      $mn = trim((string)($map_name[$i] ?? ''));
      $pb = ($picked_by[$i] ?? '');
      if($mn==='' || !in_array($mn, FW_MAP_POOL, true)) continue;
      if($pb!=='A' && $pb!=='B') $pb = null;
      $ins->execute([$id,$i,$mn,$pb]);
    }
  }

  elseif($step==='scores'){
    $sA = $_POST['sA'] ?? [];
    $sB = $_POST['sB'] ?? [];
    $sel = $pdo->prepare("SELECT id FROM match_maps WHERE match_id=? AND map_order=?");
    $upd = $pdo->prepare("UPDATE match_maps SET score_a=?, score_b=? WHERE id=?");
    for($i=1;$i<=3;$i++){
      $sa = ($sA[$i] ?? '')!=='' ? (int)$sA[$i] : null;
      $sb = ($sB[$i] ?? '')!=='' ? (int)$sB[$i] : null;
      $sel->execute([$id,$i]);
      if($mid = $sel->fetchColumn()){
        $upd->execute([$sa,$sb,$mid]);
      }
    }
  }

  elseif($step==='finish'){
    // محاسبهٔ نتیجهٔ Bo3 بر اساس score_a/score_b هر مپ
    $mm = $pdo->prepare("SELECT score_a,score_b FROM match_maps WHERE match_id=? ORDER BY map_order");
    $mm->execute([$id]);
    $A=0; $B=0;
    foreach($mm->fetchAll() as $r){
      if($r['score_a']===null || $r['score_b']===null) continue;
      if((int)$r['score_a'] > (int)$r['score_b']) $A++; elseif((int)$r['score_b'] > (int)$r['score_a']) $B++;
    }
    $statusDone = fw_status_pick($pdo,'done');
    $pdo->prepare("UPDATE matches SET score_a=?, score_b=?, status=?, finished_at=NOW() WHERE id=?")
        ->execute([$A,$B,$statusDone,$id]);

    // اگر می‌خواهی لایو تورنمنت هم خاموش شود:
    try{
      $tid = (int)$m['tournament_id'];
      if($tid) $pdo->prepare("UPDATE tournaments SET is_live=0 WHERE id=?")->execute([$tid]);
    }catch(Throwable $e){}
  }

  redirect('pages/match_manage.php?id='.$id);

}catch(Throwable $e){
  http_response_code(500);
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px;font-family:system-ui">';
  echo 'خطا: '.h($e->getMessage());
  echo '</div>';
}
