<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
header('Content-Type: application/json; charset=utf-8');

$id = (int)($_GET['id'] ?? 0);
$pdo = db();

$st = $pdo->prepare("
  SELECT m.*, s.ip_port, s.password
  FROM matches m
  LEFT JOIN servers s ON s.id=m.server_id
  WHERE m.id=?");
$st->execute([$id]);
$m = $st->fetch(PDO::FETCH_ASSOC);
if(!$m){ echo json_encode(['error'=>'not found']); exit; }

$needA = (int)$pdo->prepare("SELECT COUNT(*) FROM team_members WHERE team_id=? AND slot='starter'")
                  ->execute([(int)$m['team_a_id']]) ? (int)$pdo->lastStatement->fetchColumn() : 0;
if(!$needA){
  $q=$pdo->prepare("SELECT COUNT(*) FROM team_members WHERE team_id=?");
  $q->execute([(int)$m['team_a_id']]); $needA=(int)$q->fetchColumn();
}
$needB = (int)$pdo->prepare("SELECT COUNT(*) FROM team_members WHERE team_id=? AND slot='starter'")
                  ->execute([(int)$m['team_b_id']]) ? (int)$pdo->lastStatement->fetchColumn() : 0;
if(!$needB){
  $q=$pdo->prepare("SELECT COUNT(*) FROM team_members WHERE team_id=?");
  $q->execute([(int)$m['team_b_id']]); $needB=(int)$q->fetchColumn();
}
$needA = $needA ?: 5; $needB = $needB ?: 5;

$ra = $pdo->prepare("
  SELECT COUNT(*) FROM match_ready r
  JOIN team_members tm ON tm.user_id=r.user_id
  WHERE r.match_id=? AND tm.team_id=? AND r.is_ready=1");
$ra->execute([$id,(int)$m['team_a_id']]); $aReady = (int)$ra->fetchColumn();
$rb = $pdo->prepare("
  SELECT COUNT(*) FROM match_ready r
  JOIN team_members tm ON tm.user_id=r.user_id
  WHERE r.match_id=? AND tm.team_id=? AND r.is_ready=1");
$rb->execute([$id,(int)$m['team_b_id']]); $bReady = (int)$rb->fetchColumn();

$now = time();
$reveal = false;
$countdown = '';
$until = !empty($m['server_window_until']) ? strtotime($m['server_window_until']) : 0;

// اگر هر دو تیم کامل آماده شدند و پنجره باز نیست، خودکار ۲ دقیقه بازش کن
if($aReady >= $needA && $bReady >= $needB){
  if(!$until || $until < $now){
    $pdo->prepare("UPDATE matches SET server_window_until=DATE_ADD(NOW(), INTERVAL 120 SECOND) WHERE id=?")->execute([$id]);
    $until = $now + 120;
  }
}
// اگر زمان شروع رسیده هم می‌توانی باز کنی (اختیاری)
if(!$until && !empty($m['start_at']) && $now >= strtotime($m['start_at'])-60){
  $pdo->prepare("UPDATE matches SET server_window_until=DATE_ADD(NOW(), INTERVAL 120 SECOND) WHERE id=?")->execute([$id]);
  $until = $now + 120;
}

if($until && $until > $now){
  $reveal = true;
  $left = $until - $now;
  $mm = floor($left/60); $ss = $left%60;
  $countdown = sprintf('%02d:%02d', $mm, $ss);
}

echo json_encode([
  'a_ready'=>$aReady, 'b_ready'=>$bReady,
  'a_need'=>$needA,   'b_need'=>$needB,
  'reveal'=>$reveal,
  'server'=>$reveal?($m['ip_port']??''):'',
  'pass'  =>$reveal?($m['password']??''):'',
  'countdown'=>$countdown,
], JSON_UNESCAPED_UNICODE);
