<?php
require_once __DIR__.'/../helpers.php'; require_once __DIR__.'/../db.php'; require_once __DIR__.'/../lib/auth.php';
require_auth(); $U=auth_user(); $pdo=db();
$tid=(int)($_GET['id']??0);
$t=$pdo->prepare("SELECT * FROM teams WHERE id=?"); $t->execute([$tid]); $t=$t->fetch(); if(!$t) die('team');
$isCaptain = ($U['id']==$t['captain_id']) || is_admin();
$page_title='تیم '.h($t['name']); include __DIR__.'/_layout_header.php';

$mem=$pdo->prepare("SELECT tm.id mid, u.id uid, u.name, u.avatar_url, tm.slot, u.steam_id64
                    FROM team_members tm JOIN users u ON u.id=tm.user_id
                    WHERE tm.team_id=? ORDER BY (u.id=? ) DESC, tm.id");
$mem->execute([$tid,$t['captain_id']]); $mem=$mem->fetchAll();
?>
<div class="card">
  <div style="display:flex;gap:10px;align-items:center">
    <img src="<?=base_url($t['logo_url']?:'assets/img/logo.png')?>" style="width:56px;height:56px;border-radius:50%">
    <div>
      <h2 style="margin:0"><?=h($t['name'])?></h2>
      <div class="small">Captain: #<?=$t['captain_id']?></div>
    </div>
  </div>
</div>

<div class="card">
  <h3>اعضا</h3>
  <table class="table">
    <tr><th>پروفایل</th><th>نام استیم</th><th>نقش</th><th></th></tr>
    <?php foreach($mem as $m){ ?>
      <tr>
        <td><img src="<?=h($m['avatar_url'])?>" style="width:24px;height:24px;border-radius:50%"></td>
        <td><a class="btn alt" href="https://steamcommunity.com/profiles/<?=$m['steam_id64']?>" target="_blank"><?=h($m['name'])?></a></td>
        <td><?= $m['uid']==$t['captain_id'] ? '<span class="badge">Captain</span>' : h($m['slot']) ?></td>
        <td>
          <?php if($isCaptain && $m['uid']!=$t['captain_id']){ ?>
            <form method="post" action="<?=base_url('actions/team_kick_member.php')?>" onsubmit="return confirm('حذف عضو؟')">
              <input type="hidden" name="id" value="<?=$m['mid']?>">
              <input type="hidden" name="team_id" value="<?=$tid?>">
              <button class="btn danger">حذف عضو</button>
            </form>
          <?php } ?>
        </td>
      </tr>
    <?php } ?>
  </table>
</div>

<?php if($isCaptain){ ?>
<div class="card">
  <h3>لوگوی تیم</h3>
  <form method="post" enctype="multipart/form-data" action="<?=base_url('actions/team_update_logo.php')?>">
    <input type="hidden" name="team_id" value="<?=$tid?>">
    <input type="file" name="logo" accept="image/png,image/jpeg" required>
    <button class="btn" style="margin-top:6px">آپلود</button>
  </form>
</div>
<div class="card">
  <form method="post" action="<?=base_url('actions/team_delete.php')?>" onsubmit="return confirm('کل تیم حذف شود؟')">
    <input type="hidden" name="team_id" value="<?=$tid?>">
    <button class="btn danger">حذف تیم</button>
  </form>
</div>
<?php } ?>

<?php include __DIR__.'/_layout_footer.php';
