<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

$pdo = db();
$id  = (int)($_GET['id'] ?? 0);

// --- دریافت اطلاعات مچ + تیم‌ها + سرور
$st = $pdo->prepare("
  SELECT m.*,
         ta.name  AS a_name, tb.name  AS b_name,
         ta.logo_url AS a_logo, tb.logo_url AS b_logo,
         s.ip_port, s.password
  FROM matches m
  LEFT JOIN teams ta ON ta.id = m.team_a_id
  LEFT JOIN teams tb ON tb.id = m.team_b_id
  LEFT JOIN servers s ON s.id = m.server_id
  WHERE m.id = ?
");
$st->execute([$id]);
$m = $st->fetch();
if (!$m) { die('Match not found'); }

$U = auth_user();
$page_title = 'Match #'.$id.' — '.h($m['a_name'] ?: 'TBD').' vs '.h($m['b_name'] ?: 'TBD');
include __DIR__.'/_layout_header.php';

// --- نمایش IP/Pass از 10 دقیقه قبل از شروع
$showServer = false;
if (!empty($m['start_at'])) {
  $start = strtotime($m['start_at']);
  if (time() >= $start - 600) $showServer = true;
}

// --- برای دکمه اعتراض: چک عضویت کاربر در یکی از تیم‌های A/B
$myTeamMember = false;
if ($U && ($m['team_a_id'] || $m['team_b_id'])) {
  $q = $pdo->prepare("SELECT 1 FROM team_members WHERE user_id=? AND team_id IN(?,?) LIMIT 1");
  $q->execute([$U['id'], (int)$m['team_a_id'], (int)$m['team_b_id']]);
  $myTeamMember = (bool)$q->fetchColumn();
}

// --- فقط اگر ادمین است: لیست سرورها برای انتخاب
$servers = [];
if (is_admin()) {
  $servers = $pdo->query("SELECT id,name,ip_port FROM servers ORDER BY id DESC")->fetchAll();
}
?>

<!-- نمای کلی مچ -->
<div class="card">
  <h2 style="margin:0 0 6px"><?=h($m['a_name'] ?: 'TBD')?> <span class="badge">VS</span> <?=h($m['b_name'] ?: 'TBD')?></h2>
  <div class="small">وضعیت: <strong><?=h($m['status'] ?: '—')?></strong> | شروع: <?=h($m['start_at'] ?: 'نامشخص')?></div>

  <?php if ($showServer && !empty($m['ip_port'])) { ?>
    <div style="margin-top:8px">
      <strong>Server:</strong> <?=h($m['ip_port'])?>
      <?php if (!empty($m['password'])) { ?> | <strong>Pass:</strong> <?=h($m['password'])?><?php } ?>
    </div>
  <?php } else { ?>
    <div class="small" style="margin-top:8px;opacity:.8">اطلاعات سرور در زمان شروع نمایش داده می‌شود.</div>
  <?php } ?>
</div>

<!-- لابی -->
<div class="card" style="display:flex;justify-content:space-between;align-items:center">
  <div><strong>لابی مسابقه</strong></div>
  <a class="btn alt" href="<?=base_url('pages/match_lobby.php?id='.$id)?>">ورود به لابی</a>
</div>

<!-- پخش زنده (در صورت وجود) -->
<?php if (!empty($m['stream_url'])) { ?>
  <div class="card">
    <h3 style="margin-top:0">پخش زنده</h3>
    <div style="position:relative;padding-top:56.25%">
      <iframe
        src="<?=h($m['stream_url'])?>"
        allowfullscreen
        style="position:absolute;inset:0;width:100%;height:100%;border:0"></iframe>
    </div>
  </div>
  
<?php } 
// بعد از کارت پخش زنده و قبل از ابزار ادمین
$mm = $pdo->prepare("SELECT * FROM match_maps WHERE match_id=? ORDER BY map_order");
$mm->execute([$id]);
$maps = $mm->fetchAll(PDO::FETCH_ASSOC);

if ($maps) {
?>
  <div class="card">
    <h3 style="margin:0 0 8px">جزئیات Bo3</h3>
    <div class="grid cols-3" style="gap:10px">
      <?php foreach ($maps as $row):
        $img = fw_map_img((string)$row['map_name']);
        $pickerLabel = '—';
        if ($row['picked_by'] === 'A') $pickerLabel = 'Picker: A — '.($m['a_name'] ?: 'Team A');
        elseif ($row['picked_by'] === 'B') $pickerLabel = 'Picker: B — '.($m['b_name'] ?: 'Team B');

        $scoreTxt = '';
        if ($row['score_a'] !== null && $row['score_b'] !== null) {
          $scoreTxt = (int)$row['score_a'].' : '.(int)$row['score_b'];
        }
      ?>
        <div class="card" style="padding:0;overflow:hidden">
          <div style="position:relative;min-height:160px;background:url('<?=h($img)?>') center/cover no-repeat;">
            <div style="position:absolute;inset:0;background:linear-gradient(to top, rgba(0,0,0,.6), rgba(0,0,0,.25))"></div>

            <div style="position:absolute;left:12px;right:12px;top:10px;display:flex;justify-content:space-between;gap:8px">
              <span class="badge">Map <?= (int)$row['map_order'] ?></span>
              <span class="badge"><?= h($row['map_name']) ?></span>
            </div>

            <div style="position:absolute;left:12px;right:12px;bottom:10px">
              <div class="small"><?= h($pickerLabel) ?></div>
              <?php if ($scoreTxt) { ?>
                <div class="badge" style="margin-top:6px"><?= h($scoreTxt) ?></div>
              <?php } else { ?>
                <div class="small" style="opacity:.8;margin-top:6px">نتیجه ثبت نشده</div>
              <?php } ?>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  </div>
<?php } ?>


<!-- ابزار ادمین: لینک صفحهٔ مدیریت + فرم سریع -->
<?php if (is_admin()) { ?>
  <div class="card">
    <div style="display:flex;gap:8px;justify-content:flex-end;margin-bottom:8px">
      <a class="btn" href="<?=base_url('pages/match_manage.php?id='.$id)?>">ویرایش مسابقه (پنل مرحله‌ای)</a>
    </div>

    <h3 style="margin:0 0 8px">مدیریت سریع (ادمین)</h3>
    <form method="post" action="<?=base_url('actions/match_report_result.php')?>">
      <input type="hidden" name="id" value="<?=$id?>">

      <div class="grid cols-2">
        <div>
          <label>نتیجهٔ کلی</label>
          <select name="result">
            <option value="A">برد تیم A</option>
            <option value="B">برد تیم B</option>
          </select>
        </div>
        <div>
          <label>Knife Winner</label>
          <select name="knife_winner">
            <option value="">-</option>
            <option value="A">A</option>
            <option value="B">B</option>
          </select>
        </div>
      </div>

      <label style="margin-top:8px">امتیاز (اختیاری)</label>
      <div class="grid cols-2">
        <input type="number" name="score_a" min="0" placeholder="A">
        <input type="number" name="score_b" min="0" placeholder="B">
      </div>

      <div class="grid cols-2" style="margin-top:8px">
        <div>
          <label>زمان شروع (YYYY-MM-DD HH:MM:SS)</label>
          <input name="start_at" value="<?=h($m['start_at'])?>">
        </div>
        <div>
          <label>Stream URL (اختیاری)</label>
          <input name="stream_url" value="<?=h($m['stream_url'])?>">
        </div>
      </div>

      <?php if (!empty($servers)) { ?>
        <label style="margin-top:8px">سرور</label>
        <select name="server_id">
          <option value="">—</option>
          <?php foreach($servers as $s){ ?>
            <option value="<?=$s['id']?>" <?=$m['server_id']==$s['id']?'selected':''?>>
              #<?=$s['id']?> — <?=h($s['name'])?> (<?=h($s['ip_port'])?>)
            </option>
          <?php } ?>
        </select>
      <?php } ?>

      <button class="btn" style="margin-top:10px">ذخیره</button>
    </form>
  </div>
<?php } ?>

<!-- RCON ادمین -->
<?php if (is_admin() && !empty($m['server_id'])) {
  $sv = $pdo->prepare("SELECT * FROM servers WHERE id=?");
  $sv->execute([$m['server_id']]);
  $sv = $sv->fetch();
  if ($sv) {
?>
  <div class="card">
    <h3 style="margin-top:0">RCON</h3>
    <form method="post" action="<?=base_url('actions/rcon_exec.php')?>" class="grid cols-3" style="align-items:flex-end">
      <input type="hidden" name="match_id" value="<?=$id?>">
      <input type="hidden" name="server_id" value="<?=$m['server_id']?>">
      <div><label>دستور</label><input name="cmd" placeholder="مثلاً: status"></div>
      <div><button class="btn">اجرا</button></div>
      <div class="small">سرور: <?=h($sv['name'])?> (<?=h($sv['ip_port'])?>)</div>
    </form>

    <div style="margin-top:8px;display:flex;gap:8px;flex-wrap:wrap">
      <form method="post" action="<?=base_url('actions/rcon_preset.php')?>">
        <input type="hidden" name="match_id" value="<?=$id?>">
        <input type="hidden" name="preset" value="start">
        <button class="btn">start</button>
      </form>
      <form method="post" action="<?=base_url('actions/rcon_preset.php')?>">
        <input type="hidden" name="match_id" value="<?=$id?>">
        <input type="hidden" name="preset" value="pause">
        <button class="btn">pause</button>
      </form>
      <form method="post" action="<?=base_url('actions/rcon_preset.php')?>">
        <input type="hidden" name="match_id" value="<?=$id?>">
        <input type="hidden" name="preset" value="unpause">
        <button class="btn">unpause</button>
      </form>
      <form method="post" action="<?=base_url('actions/rcon_preset.php')?>" class="grid cols-3" style="gap:6px;align-items:center">
        <input type="hidden" name="match_id" value="<?=$id?>">
        <input type="hidden" name="preset" value="changelevel">
        <input name="map" placeholder="de_inferno">
        <button class="btn">changelevel</button>
      </form>
    </div>
  </div>
<?php } } ?>

<!-- اعتراض برای اعضای تیم‌های حاضر، بعد از اتمام مچ -->
<?php if ($m['status']==='done' && $myTeamMember) { ?>
  <div class="card">
    <a class="btn" href="<?=base_url('pages/dispute_create.php?match_id='.$id)?>">ثبت اعتراض</a>
  </div>
<?php } ?>

<?php include __DIR__.'/_layout_footer.php';
