<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); $U=auth_user();

$id = (int)($_GET['id'] ?? 0);
$pdo = db();
$m = $pdo->prepare("SELECT m.*, 
  ta.id a_id, ta.name a_name, ta.logo_url a_logo,
  tb.id b_id, tb.name b_name, tb.logo_url b_logo
  FROM matches m
  LEFT JOIN teams ta ON ta.id=m.team_a_id
  LEFT JOIN teams tb ON tb.id=m.team_b_id
  WHERE m.id=?");
$m->execute([$id]); $m=$m->fetch();
if(!$m) die('Match not found');
$page_title='لابی مچ #'.$id;
include __DIR__.'/_layout_header.php';

$myTeam = null;
if($m['a_id']){
  $st = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=?");
  $st->execute([$m['a_id'],$U['id']]); if($st->fetch()) $myTeam='A';
}
if(!$myTeam && $m['b_id']){
  $st = $pdo->prepare("SELECT 1 FROM team_members WHERE team_id=? AND user_id=?");
  $st->execute([$m['b_id'],$U['id']]); if($st->fetch()) $myTeam='B';
}

// مپ‌های انتخاب‌شده
$maps = $pdo->prepare("SELECT * FROM match_maps WHERE match_id=? ORDER BY map_order");
$maps->execute([$id]); $maps=$maps->fetchAll();
$chosen = array_column($maps,'map_name');

$pool = FW_MAP_POOL;
$knife = $m['knife_winner']; // A/B یا null
?>
<div class="grid cols-2">

  <div class="card" id="readyCard">
    <h3>Ready Check</h3>
    <div style="display:flex; align-items:center; gap:10px; justify-content:space-between">
      <div style="display:flex;align-items:center;gap:6px">
        <img src="<?=h($m['a_logo'] ?: 'assets/img/logo.png')?>" style="width:24px;height:24px;border-radius:50%"> <?=h($m['a_name'] ?: 'TBD')?>
      </div>
      <div id="readyA" class="badge">0/5</div>
      <div class="badge">VS</div>
      <div id="readyB" class="badge">0/5</div>
      <div style="display:flex;align-items:center;gap:6px">
        <?=h($m['b_name'] ?: 'TBD')?> <img src="<?=h($m['b_logo'] ?: 'assets/img/logo.png')?>" style="width:24px;height:24px;border-radius:50%">
      </div>
    </div>
    <div style="margin-top:10px">
      <?php if($myTeam){ ?>
        <form method="post" action="<?=base_url('actions/ready_toggle.php')?>" id="readyForm">
          <input type="hidden" name="match_id" value="<?=$id?>">
          <button class="btn" id="readyBtn">من آماده‌ام</button>
        </form>
      <?php } else { echo '<div class="small">فقط اعضای دو تیم می‌توانند Ready بزنند.</div>'; } ?>
      <div id="serverInfo" class="small" style="margin-top:10px">اطلاعات سرور وقتی همه آماده باشند یا زمان شروع برسد نمایش داده می‌شود.</div>
      <div id="countdown" class="small"></div>
    </div>
  </div>

  <div class="card">
    <h3>Map Pick (Bo3)</h3>
    <div class="small">Knife Winner: <strong><?= $knife ?: '—' ?></strong></div>
    <?php if(!$knife && is_admin()){ echo '<div class="small" style="color:#ccc">ادمین باید در صفحه مچ، برنده Knife را مشخص کند.</div>'; } ?>
    <ol>
      <?php foreach($maps as $mm){ echo '<li>'.$mm['map_name'].' <span class="badge">Pick '.$mm['picked_by'].'</span></li>'; } ?>
    </ol>
    <?php
    // اجازه انتخاب: Map1 توسط برنده Knife؛ Map2 توسط تیم دیگر؛ Map3 بعد از Map2 (فعلاً توسط ادمین/واجهة جدا)
    $canPick = $myTeam && $knife;
    $nextOrder = count($maps)+1;
    $whoShouldPick = null;
    if($nextOrder==1) $whoShouldPick=$knife;
    elseif($nextOrder==2) $whoShouldPick=($knife==='A'?'B':'A');
    else $whoShouldPick=null; // Map3 بعد از پایان Map2 تعیین می‌شود
    if($canPick && $whoShouldPick===$myTeam && $nextOrder<=2){
    ?>
      <form method="post" action="<?=base_url('actions/map_pick_action.php')?>">
        <input type="hidden" name="match_id" value="<?=$id?>">
        <input type="hidden" name="map_order" value="<?=$nextOrder?>">
        <input type="hidden" name="pick_by" value="<?=$myTeam?>">
        <label>انتخاب مپ (Map <?=$nextOrder?>)</label>
        <select name="map_name" required>
          <?php foreach($pool as $mp){ if(!in_array($mp,$chosen)) echo '<option>'.$mp.'</option>'; } ?>
        </select>
        <button class="btn" style="margin-top:6px">ثبت انتخاب</button>
      </form>
    <?php } else { ?>
      <div class="small">در انتظار نوبت انتخاب…</div>
    <?php } ?>
  </div>

  <div class="card">
    <h3>Prediction (اختیاری با <?=h(FW_CREDIT_NAME)?>)</h3>
    <form method="post" action="<?=base_url('actions/predict_place.php')?>">
      <input type="hidden" name="match_id" value="<?=$id?>">
      <div class="grid cols-3">
        <label><input type="radio" name="side" value="A" required> <?=h($m['a_name'] ?: 'A')?></label>
        <div class="center">VS</div>
        <label><input type="radio" name="side" value="B" required> <?=h($m['b_name'] ?: 'B')?></label>
      </div>
      <label>مبلغ (تومان)</label><input type="number" name="amount" min="1000" value="10000">
      <button class="btn" style="margin-top:6px">ثبت پیش‌بینی</button>
      <div class="small">فقط تا قبل از شروع/لایو باز است. پرداخت از کیف پول شما انجام می‌شود.</div>
    </form>
  </div>

  <div class="card" style="grid-column:1 / -1">
    <h3>چت لابی</h3>
    <div id="chatBox" style="height:220px; overflow:auto; background:#0f141d; padding:10px; border-radius:10px; border:1px solid #272e3f"></div>
    <form id="chatForm" method="post" action="<?=base_url('actions/match_chat_post.php')?>" style="margin-top:6px;display:flex;gap:6px">
      <input type="hidden" name="match_id" value="<?=$id?>">
      <input name="msg" placeholder="پیام شما…" style="flex:1">
      <button class="btn">ارسال</button>
    </form>
  </div>

</div>

<script>
// polling وضعیت آماده‌باش / سرور
let poll = () => fetch('<?=base_url('actions/match_poll_status.php')?>?id=<?=$id?>')
 .then(r=>r.json()).then(j=>{
   document.getElementById('readyA').innerText = j.a_ready + '/5';
   document.getElementById('readyB').innerText = j.b_ready + '/5';
   if(j.reveal){
     document.getElementById('serverInfo').innerHTML = '<strong>Server:</strong> '+j.server+' | <strong>Pass:</strong> '+(j.pass||'-');
   }
   document.getElementById('countdown').innerText = j.countdown || '';
 });
setInterval(poll, 4000); poll();

// چت
function loadChat(){
  fetch('<?=base_url('pages/xhr_match_chat.php')?>?id=<?=$id?>')
   .then(r=>r.text()).then(ht=>{
     const box=document.getElementById('chatBox'); box.innerHTML=ht; box.scrollTop=box.scrollHeight;
   });
}
setInterval(loadChat, 3000); loadChat();
document.getElementById('chatForm').addEventListener('submit', e=>{
  e.preventDefault();
  fetch(e.target.action,{method:'POST',body:new FormData(e.target)}).then(()=>{ e.target.msg.value=''; loadChat(); });
});
</script>

<?php include __DIR__.'/_layout_footer.php';
