<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth();
$U = auth_user();
$page_title = 'داشبورد';
include __DIR__.'/_layout_header.php';

$pdo = db();

/* کیف پول (بدون تغییر) */
$wallet = $pdo->prepare("SELECT * FROM wallets WHERE owner_type='user' AND owner_id=?");
$wallet->execute([$U['id']]);
$wallet = $wallet->fetch();
$bal = $wallet ? (int)$wallet['balance'] : 0;

/* تیم کاربر */
$team = $pdo->prepare("
  SELECT t.*
  FROM teams t
  JOIN team_members m ON t.id = m.team_id
  WHERE m.user_id=? 
  LIMIT 1
");
$team->execute([$U['id']]);
$team = $team->fetch();
?>
<div class="grid cols-2">
  <div class="card">
    <div style="display:flex;align-items:center;gap:12px">
      <!-- آواتار استیم: دست نخورده -->
      <img src="<?=h($U['avatar_url'])?>" style="width:64px;height:64px;border-radius:50%;object-fit:cover" alt="">
      <div>
        <h2 style="margin:0">خوش آمدید، <?=h($U['name'])?></h2>
        <?php list($badge,$badgeImg)=fw_badge_for_elo((int)$U['elo']); ?>
        <div class="small">
          Elo: <strong><?=h($U['elo'])?></strong> —
          <img src="<?=base_url($badgeImg)?>" style="width:18px;vertical-align:middle" alt="<?=h($badge)?>" title="<?=h($badge)?>"> <?=h($badge)?>
        </div>
      </div>
    </div>
    <hr>
    <?php if($team){ ?>
      <div style="display:flex;align-items:center;gap:10px;flex-wrap:wrap">
        <img src="<?=base_url($team['logo_url'] ?: 'assets/img/logo.png')?>" style="width:36px;height:36px;border-radius:50%;object-fit:cover" alt="">
        <div>تیم شما: <strong><?=h($team['name'])?></strong></div>
        <a class="btn" href="<?=base_url('pages/team_view.php?id='.$team['id'])?>">مشاهده تیم</a>
      </div>
    <?php } else { ?>
      <div>شما عضو هیچ تیمی نیستید. <a class="btn alt" href="<?=base_url('pages/team_create.php')?>">ساخت تیم</a></div>
    <?php } ?>
  </div>

  <!-- کیف پول: بدون تغییر -->
  <div class="card">
    <h2>کیف پول (<?=h(FW_CREDIT_NAME)?>)</h2>
    <p>موجودی: <strong><?=number_format($bal)?> تومان</strong></p>
    <form method="post" action="<?=base_url('actions/payment_create.php')?>"><label>مبلغ شارژ (تومان)</label><input type="number" name="amount" min="1000" value="20000" required><button class="btn" style="margin-top:8px">پرداخت با زرین‌پال</button></form>
  </div>
</div>

<?php
/* جدول مسابقات و تورنمنت‌ها فقط وقتی تیم داری */
$myMatches = $myTours = [];
if($team){
  // مسابقات من (در انتظار/آماده/درحال اجرا/تمام‌شده - جدیدترین 10)
  $stmt = $pdo->prepare("
    SELECT m.*, 
           ta.name a_name, ta.logo_url a_logo, 
           tb.name b_name, tb.logo_url b_logo
    FROM matches m
    LEFT JOIN teams ta ON ta.id=m.team_a_id
    LEFT JOIN teams tb ON tb.id=m.team_b_id
    WHERE (m.team_a_id=? OR m.team_b_id=?)
    ORDER BY m.start_at IS NULL, m.start_at DESC, m.id DESC
    LIMIT 10
  ");
  $stmt->execute([$team['id'], $team['id']]);
  $myMatches = $stmt->fetchAll();

  // تورنمنت‌های من (10 تا)
  $stmt = $pdo->prepare("
    SELECT tr.id, tr.title, tr.status, tr.schedule_start, tr.logo_url, tt.paid
    FROM tournament_teams tt
    JOIN tournaments tr ON tr.id=tt.tournament_id
    WHERE tt.team_id=?
    ORDER BY tr.schedule_start IS NULL, tr.schedule_start DESC, tr.id DESC
    LIMIT 10
  ");
  $stmt->execute([$team['id']]);
  $myTours = $stmt->fetchAll();
}
?>

<div class="grid cols-2">
  <div class="card">
    <h3 style="margin-top:0">مسابقات من</h3>
    <table class="table">
      <tr><th>حریف</th><th>وضعیت</th><th>زمان</th><th></th></tr>
      <?php if($myMatches){ foreach($myMatches as $m){
        $meIsA = ($m['team_a_id']==$team['id']);
        $oppName = $meIsA ? ($m['b_name'] ?: 'TBD') : ($m['a_name'] ?: 'TBD');
        $oppLogo = $meIsA ? ($m['b_logo'] ?: 'assets/img/logo.png') : ($m['a_logo'] ?: 'assets/img/logo.png');
      ?>
        <tr>
          <td>
            <img src="<?=base_url($oppLogo)?>" style="width:20px;height:20px;border-radius:50%;vertical-align:middle;margin-inline-end:6px">
            <?=h($oppName)?>
          </td>
          <td><?=h($m['status'])?></td>
          <td><?=h($m['start_at'] ?: '—')?></td>
          <td><a class="btn alt" href="<?=base_url('pages/match_view.php?id='.$m['id'])?>">مشاهده</a></td>
        </tr>
      <?php } } else { ?>
        <tr><td colspan="4" class="small">فعلاً مسابقه‌ای ثبت نشده.</td></tr>
      <?php } ?>
    </table>
  </div>

  <div class="card">
    <h3 style="margin-top:0">تورنمنت‌های من</h3>
    <table class="table">
      <tr><th>لوگو</th><th>عنوان</th><th>وضعیت</th><th>شروع</th><th></th></tr>
      <?php if($myTours){ foreach($myTours as $tr){ ?>
        <tr>
          <td><img src="<?=base_url($tr['logo_url'] ?: 'assets/img/logo.png')?>" style="width:22px;height:22px;border-radius:6px"></td>
          <td><?=h($tr['title'])?></td>
          <td><?=h($tr['status'])?> <?= $tr['paid'] ? '✅' : '❌' ?></td>
          <td><?=h($tr['schedule_start'] ?: '—')?></td>
          <td><a class="btn alt" href="<?=base_url('pages/tournament_view.php?id='.$tr['id'])?>">مشاهده</a></td>
        </tr>
      <?php } } else { ?>
        <tr><td colspan="5" class="small">فعلاً در هیچ تورنمنتی ثبت نام نکرده‌اید.</td></tr>
      <?php } ?>
    </table>
  </div>
</div>

<?php include __DIR__.'/_layout_footer.php';
