<?php
require_once __DIR__.'/../config.php';
require_once __DIR__.'/../helpers.php';

const STEAM_CURL_INSECURE = false; // فقط برای تست های خاص، در حالت عادی false

function fw_realm_origin(): string {
  $p = parse_url(FW_BASE_URL);
  $scheme = $p['scheme'] ?? 'https';
  $host   = $p['host'] ?? '';
  $port   = isset($p['port']) ? ':'.$p['port'] : '';
  return $scheme.'://'.$host.$port;
}

// helper: خواندن پارامترهای openid هم با نقطه هم با _
function oid(array $q, string $key) {
  $alt = str_replace('.', '_', $key);
  return $q[$key] ?? $q[$alt] ?? null;
}

// همه‌ی پارامترهای دریافتی را به فرم dotted برگردانیم (برای ارسال به Steam)
function oid_to_dotted(array $q): array {
  $out = [];
  foreach ($q as $k=>$v) {
    if (strpos($k, 'openid_') === 0) { $k = str_replace('_', '.', $k); }
    $out[$k] = $v;
  }
  return $out;
}

function steam_openid_login_url(): string {
  $return_to = base_url('actions/steam_callback.php');
  $params = [
    'openid.ns'         => 'http://specs.openid.net/auth/2.0',
    'openid.mode'       => 'checkid_setup',
    'openid.return_to'  => $return_to,
    'openid.realm'      => fw_realm_origin(), // فقط origin (بدون /funworld)
    'openid.identity'   => 'http://specs.openid.net/auth/2.0/identifier_select',
    'openid.claimed_id' => 'http://specs.openid.net/auth/2.0/identifier_select',
  ];
  return STEAM_OPENID_ENDPOINT.'?'.http_build_query($params);
}

// تایید پاسخ Steam
function steam_openid_validate(array $query): ?string {
  if (!oid($query, 'openid.assoc_handle')) return null;

  $params = oid_to_dotted($query);
  $params['openid.mode'] = 'check_authentication';

  $ch = curl_init(STEAM_OPENID_ENDPOINT);
  curl_setopt_array($ch, [
    CURLOPT_POST            => true,
    CURLOPT_POSTFIELDS      => http_build_query($params),
    CURLOPT_RETURNTRANSFER  => true,
    CURLOPT_SSL_VERIFYPEER  => !STEAM_CURL_INSECURE,
    CURLOPT_SSL_VERIFYHOST  => STEAM_CURL_INSECURE ? 0 : 2,
    CURLOPT_HTTPHEADER      => ['Accept: text/plain'],
    CURLOPT_USERAGENT       => 'FunWorld-OpenID/1.0',
    CURLOPT_CONNECTTIMEOUT  => 10,
    CURLOPT_TIMEOUT         => 20,
    CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
  ]);
  $res = curl_exec($ch);
  curl_close($ch);

  if ($res && strpos($res, 'is_valid:true') !== false) {
    $claimed = oid($query, 'openid.claimed_id') ?? '';
    if (preg_match('#https?://steamcommunity.com/openid/id/(\d+)#', $claimed, $m)) {
      return $m[1]; // SteamID64
    }
  }
  return null;
}
