<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';

require_auth();
if (!is_admin()) die('Only admin');

$tid = (int)($_POST['tid'] ?? 0);
if (!$tid) { echo 'bad tournament id'; exit; }

try {
  $pdo = db();

  // اگر قبلاً مچی برای این تورنمنت داریم، دوباره نساز
  $have = (int)$pdo->query("SELECT COUNT(*) FROM matches WHERE tournament_id=".$tid)->fetchColumn();
  if ($have > 0) {
    redirect('pages/tournament_view.php?id='.$tid);
  }

  // کشف وضعیت اولیه امن برای ستون status
  $statusInit = 'pending';
  $col = $pdo->query("SHOW COLUMNS FROM matches LIKE 'status'")->fetch(PDO::FETCH_ASSOC);
  if ($col) {
    $type = strtolower($col['Type'] ?? '');
    $def  = $col['Default'] ?? null;
    if ($def) $statusInit = $def;
    if (strpos($type, "enum(") !== false) {
      preg_match_all("/'([^']+)'/", $type, $m);
      $opts = $m[1] ?? [];
      $cands = ['pending','scheduled','created','open','init','ready','upcoming'];
      if ($def && in_array($def, $opts, true)) {
        $statusInit = $def;
      } else {
        foreach ($cands as $c) if (in_array($c, $opts, true)) { $statusInit = $c; break; }
        if (!in_array($statusInit, $opts, true) && $opts) $statusInit = $opts[0];
      }
    }
  }

  // تیم‌ها: اول seed (کمترین بهتر)، بعد Elo، بعد id
  $stmt = $pdo->prepare("
    SELECT t.id AS team_id,
           COALESCE(tt.seed, 999999) AS seed,
           COALESCE(t.elo, 1000) AS elo
    FROM tournament_teams tt
    JOIN teams t ON t.id = tt.team_id
    WHERE tt.tournament_id = ?
    ORDER BY (tt.seed IS NULL), tt.seed ASC, t.elo DESC, t.id ASC
  ");
  $stmt->execute([$tid]);
  $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

  if (count($rows) < 2) {
    throw new RuntimeException('برای ساخت براکت حداقل 2 تیم لازم است.');
  }

  // ستون‌های حمایتی
  $cols = $pdo->query("SHOW COLUMNS FROM matches")->fetchAll(PDO::FETCH_COLUMN, 0);
  $hasRound = in_array('round', $cols, true);
  $hasSlot  = in_array('bracket_slot', $cols, true);
  $hasScore = in_array('score_a', $cols, true) && in_array('score_b', $cols, true);

  // تعداد تیم‌ها و تکمیل به توان۲
  $n = count($rows);
  $p = 1; while ($p < $n) $p <<= 1; // ظرفیت براکت
  // نگاشت seed -> team_id
  $seeded = array_values($rows); // 0..n-1
  $seedToTeam = [];
  for ($i=0; $i<$n; $i++) $seedToTeam[$i+1] = (int)$seeded[$i]['team_id'];

  // تولید آرایش استاندارد seeding برای p
  $order = [1,2];
  $expand = function($arr){
    $n = count($arr)*2;
    $out = [];
    foreach($arr as $x){ $out[] = $x; $out[] = $n + 1 - $x; }
    return $out;
  };
  while (count($order) < $p) $order = $expand($order);
  $order = array_slice($order, 0, $p); // طول دقیق p

  // از آرایش order تیم‌ها/bye بساز
  $slots = [];
  foreach ($order as $seed) {
    $slots[] = $seed <= $n ? ($seedToTeam[$seed] ?? null) : null; // null => BYE
  }

  $pdo->beginTransaction();

  // Helper: ساخت مچ
  $insRound1 = null;
  $insOther  = null;
  if ($hasRound && $hasSlot){
    $insRound1 = $pdo->prepare("INSERT INTO matches (tournament_id, round, bracket_slot, team_a_id, team_b_id, status) VALUES (?,?,?,?,?,?)");
    $insOther  = $pdo->prepare("INSERT INTO matches (tournament_id, round, bracket_slot, status) VALUES (?,?,?,?)");
  } elseif($hasRound){
    $insRound1 = $pdo->prepare("INSERT INTO matches (tournament_id, round, team_a_id, team_b_id, status) VALUES (?,?,?,?,?)");
    $insOther  = $pdo->prepare("INSERT INTO matches (tournament_id, round, status) VALUES (?,?,?)");
  } else {
    $insRound1 = $pdo->prepare("INSERT INTO matches (tournament_id, team_a_id, team_b_id, status) VALUES (?,?,?,?)");
    // اگر round نداریم، نمی‌توانیم راندهای بعدی را پیش‌ساخت کنیم
  }

  // راند ۱: p/2 مچ
  $mIds = []; // [round][slot] => match_id
  $r1Count = (int)($p/2);
  for ($i=0; $i<$r1Count; $i++){
    $a = $slots[$i*2]   ?? null;
    $b = $slots[$i*2+1] ?? null;

    if ($hasRound && $hasSlot){
      $insRound1->execute([$tid, 1, $i+1, $a, $b, $statusInit]);
      $mid = (int)$pdo->lastInsertId();
      $mIds[1][$i+1] = $mid;
    } elseif($hasRound){
      $insRound1->execute([$tid, 1, $a, $b, $statusInit]);
      $mid = (int)$pdo->lastInsertId();
      // اسلاتی نداریم
      $mIds[1][$i+1] = $mid;
    } else {
      $insRound1->execute([$tid, $a, $b, $statusInit]);
      $mid = (int)$pdo->lastInsertId();
      $mIds[1][$i+1] = $mid;
    }
  }

  // اگر round داریم، مچ‌های راندهای بعدی را تا فینال بسازیم (خالی)
  if ($hasRound){
    $rounds = (int)round(log($p, 2)); // مثلا p=8 → 3 راند
    for ($r=2; $r<=$rounds; $r++){
      $count = (int)($p / (2 ** $r));
      for ($s=1; $s<=$count; $s++){
        if ($hasSlot){
          $insOther->execute([$tid, $r, $s, $statusInit]);
        } else {
          $insOther->execute([$tid, $r, $statusInit]);
        }
        $mIds[$r][$s] = (int)$pdo->lastInsertId();
      }
    }
  }

  // BYE ها را برنده کن و به بالا تزریق کن (فقط اگر round داریم)
  if ($hasRound){
    // تابع تزریق برنده به راند بعد
    $feedUp = function(int $round, int $slot, int $winnerTeamId) use ($pdo, $mIds, $hasSlot){
      $nextRound = $round + 1;
      if (empty($mIds[$nextRound])) return; // فینال بود
      $nextSlot  = (int)ceil($slot / 2);
      $nextId    = $mIds[$nextRound][$nextSlot] ?? 0;
      if (!$nextId) return;

      // تعیین جای تیم (A/B) بر اساس زوج/فرد بودن اسلات فعلی
      if ($slot % 2 === 1){
        $pdo->prepare("UPDATE matches SET team_a_id=? WHERE id=?")->execute([$winnerTeamId, $nextId]);
      } else {
        $pdo->prepare("UPDATE matches SET team_b_id=? WHERE id=?")->execute([$winnerTeamId, $nextId]);
      }
    };

    // اول راند ۱ را بررسی کن
    for ($s=1; $s<=$r1Count; $s++){
      $a = $slots[($s-1)*2]   ?? null;
      $b = $slots[($s-1)*2+1] ?? null;
      if (($a && !$b) || ($b && !$a)){
        $winner = $a ?: $b;
        $mid    = $mIds[1][$s];

        // این مچ را done کن (برد 2:0)
        if ($hasScore){
          $pdo->prepare("UPDATE matches SET status='done', score_a=?, score_b=?, finished_at=NOW() WHERE id=?")
              ->execute([$a?2:0, $b?2:0, $mid]);
        } else {
          $pdo->prepare("UPDATE matches SET status='done', finished_at=NOW() WHERE id=?")->execute([$mid]);
        }

        // برنده را به راند ۲ تزریق کن
        $feedUp(1, $s, (int)$winner);
      }
    }

    // حالا راندهای بالاتر را هم در صورت تشکیل تک‌طرفه، خودکار بالا ببریم
    $rounds = (int)round(log($p, 2));
    for ($r=2; $r<=$rounds; $r++){
      $count = (int)($p / (2 ** $r));
      for ($s=1; $s<=$count; $s++){
        $mid = $mIds[$r][$s] ?? 0;
        if(!$mid) continue;
        $row = $pdo->prepare("SELECT team_a_id, team_b_id, status FROM matches WHERE id=?");
        $row->execute([$mid]); $row=$row->fetch(PDO::FETCH_ASSOC);
        if(!$row) continue;

        $a = (int)($row['team_a_id'] ?? 0);
        $b = (int)($row['team_b_id'] ?? 0);

        if (($a && !$b) || ($b && !$a)){
          $winner = $a ?: $b;
          if ($hasScore){
            $pdo->prepare("UPDATE matches SET status='done', score_a=?, score_b=?, finished_at=NOW() WHERE id=?")
                ->execute([$a?2:0, $b?2:0, $mid]);
          } else {
            $pdo->prepare("UPDATE matches SET status='done', finished_at=NOW() WHERE id=?")->execute([$mid]);
          }
          $feedUp($r, $s, (int)$winner); // برو بالاتر
        }
      }
    }
  }

  $pdo->commit();
  redirect('pages/tournament_view.php?id='.$tid);

} catch (Throwable $e) {
  if(isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
  http_response_code(500);
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px;font-family:system-ui">';
  echo 'خطا در تولید براکت: '.h($e->getMessage());
  echo '</div>';
}
