<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); if(!is_admin()) die('Only admin');
$pdo = db();

try{
  $title    = trim($_POST['title'] ?? '');
  $fee      = (int) fw_digits_fa2en($_POST['entry_fee'] ?? '20000');
  $maxTeams = isset($_POST['max_teams']) && $_POST['max_teams'] !== '' ? (int) fw_digits_fa2en($_POST['max_teams']) : null;

  $startRaw = $_POST['schedule_start'] ?? '';
  $start    = fw_parse_datetime($startRaw);              // اعداد فارسی→انگلیسی + تبدیل به YYYY-MM-DD HH:MM:SS

  $logo     = fw_upload_image($_FILES['logo'] ?? [], 'tournaments'); // می‌تونه null برگرده

  if($title==='')                    throw new Exception('عنوان الزامی است');
  if($startRaw !== '' && !$start)    throw new Exception('فرمت تاریخ/ساعت نامعتبر است');

  // Map pool پیش‌فرض (برای سازگاری با صفحات نمایش)
  $mapPool = defined('FW_MAP_POOL') ? json_encode(FW_MAP_POOL, JSON_UNESCAPED_UNICODE) : json_encode([]);

  // اگر ستون‌های max_teams/map_pool داری، این INSERT کامل‌تره
  $stmt = $pdo->prepare("
    INSERT INTO tournaments (title, entry_fee, status, schedule_start, logo_url, max_teams, map_pool)
    VALUES (?, ?, 'open', ?, ?, ?, ?)
  ");
  $stmt->execute([$title, $fee, $start, $logo, $maxTeams, $mapPool]);

  audit('tournament.create','tournament',(int)$pdo->lastInsertId(), null, [
    'title'=>$title, 'fee'=>$fee, 'max'=>$maxTeams, 'start'=>$start
  ]);

  redirect('pages/tournaments.php');

}catch(Throwable $e){
  echo '<div style="padding:16px;background:#1b2330;color:#f8d7da;border:1px solid #842029;border-radius:8px;font-family:system-ui">';
  echo 'خطا در ساخت تورنمنت: '.h($e->getMessage());
  echo '</div>';
}
