<?php
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../lib/auth.php';
require_auth(); $U = auth_user(); $pdo=db();

/* ویرایش نام/تگ/لوگو */
if(isset($_POST['team_id']) && !isset($_POST['slot']) && !isset($_POST['remove_mid'])){
  $team_id=(int)$_POST['team_id'];
  $t = $pdo->prepare("SELECT * FROM teams WHERE id=? AND captain_id=?"); $t->execute([$team_id,$U['id']]); $t=$t->fetch();
  if(!$t) die('دسترسی ندارید');
  $name=trim($_POST['name']??''); $tag=trim($_POST['tag']??'');
  $logoUrl=$t['logo_url'];
  if(!empty($_FILES['logo']['name'])){
    $ext=strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    if(!in_array($ext,['png','jpg','jpeg'])) die('PNG/JPG');
    $fname='team_'.time().'_'.mt_rand(1000,9999).'.'.$ext;
    $dest=__DIR__.'/../assets/img/'.$fname;
    if(!move_uploaded_file($_FILES['logo']['tmp_name'],$dest)) die('آپلود ناموفق');
    $logoUrl='assets/img/'.$fname;
  }
  $before = $t;
  $pdo->prepare("UPDATE teams SET name=?, tag=?, logo_url=? WHERE id=?")->execute([$name,$tag,$logoUrl,$team_id]);
$after = ['name'=>$name,'tag'=>$tag,'logo_url'=>$logoUrl];
audit('team.update','team',$team_id,$before,$after);
  redirect('pages/team_manage.php');
}

/* تغییر نقش starter/sub */
if(isset($_POST['mid']) && isset($_POST['slot'])){
  $mid=(int)$_POST['mid']; $slot=$_POST['slot']=='sub'?'sub':'starter';
  // فقط کپتن تیم حق دارد
  $chk=$pdo->prepare("SELECT t.captain_id FROM team_members m JOIN teams t ON t.id=m.team_id WHERE m.id=?");
  $chk->execute([$mid]); $cap=$chk->fetchColumn();
  if($cap!=$U['id']) die('دسترسی ندارید');
  $pdo->prepare("UPDATE team_members SET slot=? WHERE id=?")->execute([$slot,$mid]);
  audit('team.member.role','team_member',$mid,null,['slot'=>$slot]);
audit('team.member.remove','team_member',$mid);
  redirect('pages/team_manage.php');
}

/* حذف عضو */
if(isset($_POST['remove_mid'])){
  $mid=(int)$_POST['remove_mid'];
  $chk=$pdo->prepare("SELECT t.captain_id, m.user_id FROM team_members m JOIN teams t ON t.id=m.team_id WHERE m.id=?");
  $chk->execute([$mid]); $row=$chk->fetch();
  if(!$row || $row['captain_id']!=$U['id']) die('دسترسی ندارید');
  if($row['user_id']==$U['id']) die('کپتن را نمی‌توان حذف کرد');
  $pdo->prepare("DELETE FROM team_members WHERE id=?")->execute([$mid]);
  redirect('pages/team_manage.php');
}

die('درخواست نامعتبر');
