<?php
// bot/shopfun/webapp/support-admin.php
if (session_status()===PHP_SESSION_NONE) session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Tehran');

/* Auth */
$auth_ok = false;
if (is_file(__DIR__.'/../auth.php')) { require_once __DIR__.'/../auth.php'; $auth_ok = function_exists('auth_user') ? !!auth_user() : !!($_SESSION['auth_user'] ?? null); }
elseif (is_file(__DIR__.'/../funs/auth.php')) { require_once __DIR__.'/../funs/auth.php'; $auth_ok = function_exists('auth_user') ? !!auth_user() : !!($_SESSION['auth_user'] ?? null); }
else { $auth_ok = !!($_SESSION['auth_user'] ?? null); }
if (!$auth_ok) { header('Location: ../admin-monitor.php'); exit; }

/* Paths */
function jload($p,$d=[]){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:$d; }
$SUPPORT_BASE = realpath(__DIR__.'/..').'/support';
@mkdir($SUPPORT_BASE,0777,true);

$uid = preg_replace('/\D/','', (string)($_GET['uid'] ?? ''));

/* Close chat (delete all variants) */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['close_uid'])) {
  $cuid = preg_replace('/\D/','', (string)$_POST['close_uid']);
  if ($cuid) {
    $dir = $SUPPORT_BASE.'/'.$cuid; // primary
    if (is_dir($dir)) {
      $it = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir, FilesystemIterator::SKIP_DOTS), RecursiveIteratorIterator::CHILD_FIRST);
      foreach($it as $f){ $f->isDir()? @rmdir($f->getPathname()) : @unlink($f->getPathname()); }
      @rmdir($dir);
    }
    // legacy files
    $legacy1 = $SUPPORT_BASE.'/'.$cuid.'.json';
    $legacy2 = dirname($SUPPORT_BASE).'/support/'.$cuid.'/messages.json';
    if (is_file($legacy1)) @unlink($legacy1);
    if (is_file($legacy2)) @unlink($legacy2);
  }
  header('Location: support-admin.php'); exit;
}

/* List chats */
function list_chats($base){
  $items=[];
  foreach ((array)glob($base.'/*', GLOB_ONLYDIR) as $dir){
    $id = basename($dir);
    $msgs = jload($dir.'/messages.json', []);
    $last = $msgs ? end($msgs) : [];
    $ts   = isset($last['ts']) ? (int)$last['ts'] : 0;
    $preview = (isset($last['type']) && $last['type']==='text')
      ? mb_substr((string)($last['text']??''),0,40)
      : '['.($last['type']??'file').']';
    $items[] = ['uid'=>$id,'count'=>count($msgs),'last_ts'=>$ts,'last'=>$preview];
  }
  usort($items, function($a,$b){
    $ba = isset($b['last_ts']) ? (int)$b['last_ts'] : 0;
    $aa = isset($a['last_ts']) ? (int)$a['last_ts'] : 0;
    if ($ba===$aa) return 0;
    return ($ba>$aa)?-1:1;
  });
  return $items;
}
$chats = list_chats($SUPPORT_BASE);

/* User meta */
$USER_DIR = realpath(__DIR__.'/..').'/data/'.($uid ?: '0');
$username = @file_get_contents($USER_DIR.'/last.txt') ?: '';
$avatar   = is_file($USER_DIR.'/avatar.jpg') ? ('../data/'.$uid.'/avatar.jpg') : '../assets/profile.png';
$steam    = @file_get_contents($USER_DIR.'/steamid.txt') ?: '';
?>
<!doctype html><html lang="fa" dir="rtl"><head>
<meta charset="utf-8"/><meta name="viewport" content="width=device-width,initial-scale=1"/>
<title>پشتیبانی | FunWorld</title>
<style>
:root{--bg:#0b1220;--card:#0f172a;--line:#1f2937;--text:#e5e7eb;--muted:#94a3b8}
*{box-sizing:border-box} body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
a{color:#93c5fd;text-decoration:none}
.wrap{display:grid;grid-template-columns:280px 1fr;min-height:100vh}
.side{border-left:1px solid var(--line);overflow:auto}
.head{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid var(--line);background:#0f172a}
.list{padding:8px;display:flex;flex-direction:column;gap:8px}
.item{border:1px solid var(--line);border-radius:10px;padding:8px;background:#0e1525}
.item:hover{filter:brightness(1.05)}
.badge{border:1px solid var(--line);border-radius:999px;padding:0 8px;background:#0b1220;font-size:12px}
.main{display:flex;flex-direction:column}
.header{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;border-bottom:1px solid var(--line);background:#0f172a}
.row{display:flex;gap:8px;align-items:center;flex-wrap:wrap}
.btn{padding:8px 10px;border:1px solid var(--line);border-radius:10px;background:#1a273e;color:#e5e7eb;cursor:pointer}
.btn-danger{background:#3a1a1a}
.input{flex:1;padding:10px;border:1px solid var(--line);border-radius:10px;background:#0b1220;color:#e5e7eb}
.chat{flex:1;display:flex;flex-direction:column;gap:8px;overflow:auto;padding:10px}
.msg{max-width:70%;padding:8px 10px;border-radius:14px}
.me{align-self:flex-end;background:#1d2a44}
.user{align-self:flex-start;background:#111827}
</style>
</head><body>
<div class="wrap">
  <aside class="side">
    <div class="head">
      <div>گفت‌وگوها</div>
      <a class="btn" href="../admin-monitor.php">⟵ مانیتورینگ</a>
    </div>
    <div class="list">
      <?php if(!$chats): ?>
        <div class="item">گفت‌وگویی ندارید.</div>
      <?php else: foreach($chats as $c): ?>
        <a class="item" href="?uid=<?=htmlspecialchars($c['uid'])?>">
          <div style="display:flex;justify-content:space-between;align-items:center;">
            <div><b>#<?=htmlspecialchars($c['uid'])?></b> <span class="badge"><?= (int)$c['count'] ?> پیام</span></div>
            <div style="color:var(--muted);font-size:12px"><?= htmlspecialchars($c['last']) ?></div>
          </div>
        </a>
      <?php endforeach; endif; ?>
    </div>
  </aside>

  <section class="main">
    <div class="header">
      <div class="row">
        <img src="<?=htmlspecialchars($avatar)?>" style="width:36px;height:36px;border-radius:999px;border:1px solid var(--line)">
        <div>
          <div><?= $username ? htmlspecialchars($username) : 'کاربر' ?> <span class="badge">UID: <?= $uid ?: '—' ?></span></div>
          <?php if($steam): ?><div style="font-size:12px;color:var(--muted)">Steam: <?= htmlspecialchars($steam) ?></div><?php endif; ?>
        </div>
      </div>
      <div class="row">
        <?php if($uid): ?>
          <form method="post" onsubmit="return confirm('کل چت پاک شود؟')">
            <input type="hidden" name="close_uid" value="<?=htmlspecialchars($uid)?>">
            <button class="btn btn-danger" type="submit">بستن چت</button>
          </form>
        <?php endif; ?>
      </div>
    </div>

    <?php if(!$uid): ?>
      <div class="item" style="margin:10px">از ستون کنار، گفت‌وگو را انتخاب کنید.</div>
    <?php else: ?>
      <div id="chat" class="chat"></div>
      <div class="row" style="padding:10px;border-top:1px solid var(--line)">
        <input id="msg" class="input" placeholder="پیام ادمین...">
        <input id="file" type="file" accept="image/*,audio/*" style="display:none">
        <button class="btn" onclick="document.getElementById('file').click()">📎</button>
        <button class="btn" onclick="send()">ارسال</button>
      </div>
    <?php endif; ?>
  </section>
</div>

<?php if($uid): ?>
<script>
let LAST=0,POLL=null;
function row(m){
  const d=document.createElement('div');
  d.className='msg '+(m.from==='admin'?'me':'user');
  if(m.type==='text'){ d.textContent=m.text||''; }
  else if(m.type==='image'){ d.innerHTML=`<img src="../webapp/${m.url}" style="max-width:60%;border-radius:10px">`; }
  else if(m.type==='audio'){ d.innerHTML=`<audio controls src="../webapp/${m.url}"></audio>`; }
  return d;
}
async function load(){
  const fd=new URLSearchParams(); fd.append('uid','<?=$uid?>'); fd.append('action','load'); fd.append('after',LAST);
  const r=await fetch('support-admin_api.php',{method:'POST',body:fd}).then(x=>x.json()).catch(()=>({ok:false}));
  if(!r.ok) return;
  const box=document.getElementById('chat');
  (r.items||[]).forEach(m=>{ box.appendChild(row(m)); LAST=Math.max(LAST, m.id||0); box.scrollTop=box.scrollHeight; });
}
async function send(){
  const text=document.getElementById('msg').value.trim();
  const file=document.getElementById('file').files[0];
  const url='support-admin_api.php';
  if(file){
    const fd=new FormData(); fd.append('uid','<?=$uid?>'); fd.append('file', file);
    const r=await fetch(url,{method:'POST',body:fd}).then(x=>x.json()).catch(()=>({ok:false}));
    if(r.ok){ document.getElementById('file').value=''; }
  }else if(text){
    const fd=new URLSearchParams(); fd.append('uid','<?=$uid?>'); fd.append('action','send'); fd.append('text', text);
    const r=await fetch(url,{method:'POST',body:fd}).then(x=>x.json()).catch(()=>({ok:false}));
    if(r.ok){ document.getElementById('msg').value=''; }
  }
}
function start(){ if(POLL) return; load(); POLL=setInterval(load,2000); }
function stop(){ if(POLL){ clearInterval(POLL); POLL=null; } }
document.addEventListener('visibilitychange',()=>{ document.hidden?stop():start(); });
start();
</script>
<?php endif; ?>
</body></html>
