<?php
// orders-manage.php  (full replace)
session_start();
error_reporting(E_ALL);
ini_set('display_errors',1);
date_default_timezone_set('Asia/Tehran');

require_once __DIR__.'/funs/auth.php';
auth_gate('orders-manage.php');

function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }
function jf($p){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:null; }
function jsave($p,$a){ @file_put_contents($p,json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }

/* === Telegram === */
if(!defined('BOT_TOKEN')) define('BOT_TOKEN','8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8');
if(!defined('TELEGRAM_ADMIN_CHAT')) define('TELEGRAM_ADMIN_CHAT',7167180963); // ادمین اصلی
function tg_send($chat,$text){
  $u="https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=".$chat."&text=".urlencode($text);
  @file_get_contents($u);
}
/* اگر در آینده message_id ادمین را ذخیره کردی، می‌توانی این را برای ویرایش فعال کنی */
// function tg_edit($chat,$mid,$text){
//   $u="https://api.telegram.org/bot".BOT_TOKEN."/editMessageText?chat_id=$chat&message_id=$mid&text=".urlencode($text);
//   @file_get_contents($u);
// }

/* === AJAX status change === */
if(isset($_POST['ajax'],$_POST['oid'],$_POST['status'])){
  $oid=basename($_POST['oid']);
  $file=__DIR__."/orders/$oid.json";
  $ok=false; $msg='ناموفق';
  if(is_file($file)){
    $d=jf($file);
    if($d){
      $new=($_POST['status']==='approved')?'approved':'incomplete';
      $old=$d['status'] ?? 'pending';
      if($old!=='approved' || $new!=='approved'){ // اجازهٔ تغییر از/به ناقص
        $d['status']=$new; jsave($file,$d); $ok=true; $msg='وضعیت بروز شد';
        // پیام به کاربر
        if(!empty($d['buyer_chat'])){
          if($new==='approved'){
            tg_send($d['buyer_chat'],"✅ سفارش شما تایید و تحویل داده شد.\nمحصول: {$d['product_id']}\nمبلغ: {$d['price']}\nاز خرید شما از Fun World سپاسگزاریم 🪐");
          } else {
            tg_send($d['buyer_chat'],"⛔ سفارش شما ناقص/در انتظار اطلاعات است.\nپشتیبانی: @Fun_Support_org");
          }
        }
        // پیام به ادمین اصلی
        $t = ($new==='approved'?'✅ «تایید شد»':'⛔ «ناقص»');
        $who = auth_user();
        tg_send(TELEGRAM_ADMIN_CHAT,"🛠 تغییر وضعیت از پنل وب\nسفارش: {$d['id']}\nمحصول: {$d['product_id']}\nکاربر: {$d['buyer_id']}\nوضعیت جدید: $t\nتوسط: $who");
      }
    }
  }
  header('Content-Type: application/json; charset=UTF-8');
  echo json_encode(['ok'=>$ok,'msg'=>$msg]); exit;
}

/* === list orders === */
$dir=__DIR__.'/orders'; $list=[];
if(is_dir($dir)){
  foreach(glob($dir.'/*.json') as $f){ $o=jf($f); if(!$o) continue; $o['_file']=basename($f,'.json'); $list[]=$o; }
  usort($list,function($a,$b){ return (int)($b['created_at']??0) <=> (int)($a['created_at']??0); });
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1" />
<title>مدیریت سفارشات | FunWorld</title>
<style>
  :root{--bg:#0b1220;--card:#0f172a;--muted:#94a3b8;--text:#e5e7eb;--line:#1f2937;--ok:#22c55e;--bad:#ef4444;--wait:#f59e0b;}
  *{box-sizing:border-box} body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
  .container{max-width:1100px;margin:0 auto;padding:20px}
  a{color:#93c5fd;text-decoration:none}
  .card{background:var(--card);border:1px solid var(--line);border-radius:18px;padding:18px}
  h1{margin:0 0 12px;font-size:18px}
  .top{display:flex;justify-content:space-between;align-items:center;margin-bottom:12px}
  table{width:100%;border-collapse:separate;border-spacing:0 8px}
  th{color:var(--muted);font-weight:600;font-size:12px;text-align:right;padding:0 8px}
  td{background:#0b1220;border:1px solid var(--line);border-left:none;border-right:none;padding:10px 8px;border-radius:10px;vertical-align:middle}
  .badge{display:inline-block;padding:4px 10px;border-radius:999px;font-size:12px;border:1px solid var(--line);white-space:nowrap}
  .b-ok{background:rgba(34,197,94,.15); border-color:rgba(34,197,94,.4); color:#86efac}
  .b-bad{background:rgba(239,68,68,.15); border-color:rgba(239,68,68,.4); color:#fecaca}
  .b-wait{background:rgba(245,158,11,.15); border-color:rgba(245,158,11,.4); color:#fde68a}
  .btn{padding:6px 10px;border:1px solid var(--line);background:#1d2a44;border-radius:10px;font-size:12px;cursor:pointer;margin-inline-start:6px}
  /* modal */
  .modal{position:fixed;inset:0;background:rgba(0,0,0,.55);display:none;align-items:center;justify-content:center;padding:16px;z-index:1000}
  .modal.open{display:flex}
  .modal-card{width:100%;max-width:560px;background:#0f172a;border:1px solid var(--line);border-radius:16px;padding:16px}
  .modal-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
  .close{cursor:pointer;border:none;background:#1f2937;color:#e5e7eb;border-radius:10px;padding:6px 10px}
  .dl{display:grid;grid-template-columns:150px 1fr;gap:8px}
  .dl div{padding:6px 8px;border:1px solid var(--line);border-radius:10px;background:#0b1220}
  .action-row{display:flex;gap:8px;justify-content:flex-end;margin-top:10px}
  /* toast */
  .toast{position:fixed;top:20px;left:50%;transform:translateX(-50%);background:#0f172a;border:1px solid #1f2937;color:#e5e7eb;padding:10px 14px;border-radius:12px;display:none;z-index:1100}
</style>
</head>
<body>
  <div class="container">
    <div class="top">
      <h1>مدیریت سفارشات </h1>
      <div><a class="btn" href="admin-monitor.php">⟵ بازگشت به مانیتورینگ</a></div>
    </div>
    <div class="card">
      <table>
        <thead>
          <tr>
            <th>تاریخ</th>
            <th>کاربر</th>
            <th>شماره</th>
            <th>استیم آیدی</th>
            <th>محصول</th>
            <th>مبلغ</th>
            <th>سرور</th>
            <th>وضعیت</th>
            <th>جزئیات</th>
          </tr>
        </thead>
        <tbody>
          <?php if(empty($list)){ ?>
            <tr><td colspan="9" style="text-align:center" class="muted">سفارشی یافت نشد.</td></tr>
          <?php } else { foreach($list as $o){
            $st=$o['status']??'pending';
            $cls=$st==='approved'?'b-ok':($st==='pending'?'b-wait':'b-bad');
            $txt=$st==='approved'?'تایید شده':($st==='pending'?'در انتظار':'ناقص');
            $steam = $o['steamid'] ?? '-';
            $steamLink = ($steam && preg_match('/^\d+$/',$steam)) ? "https://steamcommunity.com/profiles/{$steam}" : null;
          ?>
            <tr>
              <td><?= isset($o['created_at'])?date('Y-m-d H:i',(int)$o['created_at']):'—' ?></td>
              <td><?= h($o['username'] ?? '-') ?> (<?= h($o['buyer_id'] ?? '-') ?>)</td>
              <td><?= h($o['phone'] ?? '-') ?></td>
              <td>
                <?= h($steam ?: '-') ?>
                <?php if($steamLink): ?>
                  <a href="<?=$steamLink?>" target="_blank" class="btn" style="padding:3px 8px">مشاهده پروفایل استیم</a>
                <?php endif; ?>
              </td>
              <td><?= h($o['product_id'] ?? '-') ?></td>
              <td><?= number_format((int)($o['price'] ?? 0)) ?></td>
              <td><?= h($o['server'] ?? '-') ?></td>
              <td><span class="badge <?=$cls?>"><?=$txt?></span></td>
              <td>
                <button class="btn"
                  data-oid="<?=h($o['_file'])?>"
                  data-raw='<?=h(json_encode($o,JSON_UNESCAPED_UNICODE))?>'
                >جزئیات</button>
              </td>
            </tr>
          <?php } } ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- MODAL -->
  <div class="modal" id="modal">
    <div class="modal-card">
      <div class="modal-header">
        <div style="font-weight:700">جزئیات سفارش</div>
        <button class="close" data-close>بستن</button>
      </div>
      <div class="dl" id="dl"></div>
      <div class="action-row">
        <button class="btn" id="btn-bad">علامت «ناقص»</button>
        <button class="btn" id="btn-ok">تایید سفارش</button>
      </div>
    </div>
  </div>
  <div class="toast" id="toast">ذخیره شد</div>

<script>
const modal=document.getElementById('modal');
const dl=document.getElementById('dl');
const toast=document.getElementById('toast');
let curOid=null;

function showToast(t){
  toast.textContent=t||'انجام شد'; toast.style.display='block';
  setTimeout(()=>toast.style.display='none', 4000);
}
function openModal(oid,data){
  curOid=oid;
  dl.innerHTML='';
  const rows=[
    ['کاربر', (data.username||'-')+' (#'+(data.buyer_id||'-')+')'],
    ['شماره', data.phone||'-'],
    ['استیم آیدی', data.steamid||'-'],
    ['محصول', data.product_id||'-'],
    ['مبلغ', (data.price?Number(data.price).toLocaleString():'0')],
    ['سرور', data.server||'-'],
    ['وضعیت', data.status||'-'],
    ['تاریخ', data.created_at? new Date(data.created_at*1000).toLocaleString('fa-IR'): '—']
  ];
  rows.forEach(r=>{
    const k=document.createElement('div'); k.textContent=r[0];
    const v=document.createElement('div'); v.textContent=r[1];
    dl.appendChild(k); dl.appendChild(v);
  });
  modal.classList.add('open');
}
function closeModal(){ modal.classList.remove('open'); curOid=null; }

document.addEventListener('click',e=>{
  if(e.target.matches('[data-close]') || e.target===modal) closeModal();
  if(e.target.matches('.btn[data-oid]')){
    const oid=e.target.dataset.oid;
    const raw=JSON.parse(e.target.dataset.raw);
    openModal(oid,raw);
  }
});
async function updateStatus(s){
  if(!curOid) return;
  const fd=new FormData(); fd.append('ajax',1); fd.append('oid',curOid); fd.append('status',s);
  const res=await fetch(location.href,{method:'POST',body:fd});
  const js=await res.json();
  showToast(js.ok? 'عملیات انجام شد' : (js.msg||'خطا'));
  if(js.ok){ setTimeout(()=>location.reload(), 1200); }
}
document.getElementById('btn-ok').onclick = ()=>updateStatus('approved');
document.getElementById('btn-bad').onclick= ()=>updateStatus('incomplete');
</script>
</body>
</html>
