<?php
require_once __DIR__.'/db.php';

// users from data/*/*.txt
foreach (glob(__DIR__."/data/*", GLOB_ONLYDIR) as $dir){
  $uid = basename($dir);
  if(!ctype_digit($uid)) continue;
  $u = db_user_get($uid);
  $fields = [];
  foreach (['price','phone','steamid','step','server','pending_pid'] as $k){
    $v = @file_get_contents("$dir/$k.txt");
    if($v!==false && $v!=="") $fields[$k] = ($k==='price'? (int)$v : trim($v));
  }
  if($fields) db_user_update($uid, $fields);
}

echo "Users migrated\n";

// discount codes from discounts/codes.json
$codes = @json_decode(@file_get_contents(__DIR__.'/discounts/codes.json'), true) ?: [];
$pdo = DB::pdo();
foreach($codes as $code=>$r){
  $pdo->prepare("INSERT IGNORE INTO discount_codes (code,percent,expire_at,is_active,created_at,uses,servers)
     VALUES (?,?,?,?,?,?,?)")->execute([
       $code,(int)$r['percent'],(int)($r['expire_at']??0),(int)!empty($r['is_active']),
       (int)($r['created_at']??time()),(int)($r['uses']??0),
       !empty($r['servers']) ? (is_array($r['servers'])? implode(',',$r['servers']) : $r['servers']) : '1,2,1+2'
     ]);
}
echo "Discounts migrated\n";

// orders from orders/*.json
foreach (glob(__DIR__."/orders/*.json") as $f){
  $o = @json_decode(@file_get_contents($f), true);
  if(!$o || empty($o['id'])) continue;
  try{
    db_order_add($o);
  }catch(Exception $e){}
}
echo "Orders migrated\n";
