<?php
/* Admin Monitoring Dashboard - FunWorld
 * Password: 8585
 * DB: uses config.php / db.php
 * Tables: orders (migrated), users, optional bot_heartbeat
 */

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Tehran');

/* ========= DB bootstrap ========= */
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';

function db(): PDO {
  static $conn = null;
  if ($conn instanceof PDO) return $conn;
  if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) { $conn=$GLOBALS['pdo']; return $conn; }

  if (defined('DB_DSN')) $dsn = DB_DSN;
  else {
    $host = defined('DB_HOST') ? DB_HOST : 'localhost';
    $name = defined('DB_NAME') ? DB_NAME : 'funworld';
    $dsn  = "mysql:host={$host};dbname={$name};charset=utf8mb4";
  }
  if (defined('DB_USER'))        $user = DB_USER;
  elseif (defined('DB_USERNAME'))$user = DB_USERNAME; else $user = 'root';
  if (defined('DB_PASS'))        $pass = DB_PASS;
  elseif (defined('DB_PASSWORD'))$pass = DB_PASSWORD; else $pass = '';

  $conn = new PDO($dsn,$user,$pass,[
    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC
  ]);
  return $conn;
}

/* ========= Security ========= */
/* ========= Security (new) ========= */
require_once __DIR__.'/funs/auth.php';
auth_gate('admin-monitor.php'); // login گیت
$AUTH_USER = auth_user();
$AUTH_ROLE = auth_role(); // 'sudo' | 'admin'

/* ========= Ensure heartbeat table ========= */
try {
  db()->exec("CREATE TABLE IF NOT EXISTS bot_heartbeat (
    id TINYINT PRIMARY KEY,
    last_seen INT NULL,
    start_time INT NULL,
    version VARCHAR(32) NULL
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
  $c = db()->query("SELECT COUNT(*) c FROM bot_heartbeat WHERE id=1")->fetch()['c'] ?? 0;
  if ((int)$c===0) {
    $now=time();
    db()->prepare("INSERT INTO bot_heartbeat(id,last_seen,start_time,version) VALUES(1,?,?,?)")
       ->execute([$now,$now,'1.0']);
  }
} catch (Throwable $e) {}

/* ========= Queries ========= */
// Heartbeat
$hb       = db()->query("SELECT * FROM bot_heartbeat WHERE id=1")->fetch();
$lastSeen = (int)($hb['last_seen'] ?? 0);
$startAt  = (int)($hb['start_time'] ?? 0);
$now      = time();
$diff     = $lastSeen ? ($now - $lastSeen) : null;
$isOnline = ($lastSeen && $diff <= 120);

// Pagination
$perPage   = 5;
$page      = max(1, (int)($_GET['page'] ?? 1));
$totalRows = (int)(db()->query("SELECT COUNT(*) c FROM orders")->fetch()['c'] ?? 0);
$pages     = max(1, (int)ceil($totalRows / $perPage));
$offset    = ($page - 1) * $perPage;

// Orders list (map schema from migration: id/buyer_id/product_id/price/server/status/created_at/phone/steamid/username)
$st = db()->prepare("
  SELECT
    id         AS oid,
    buyer_id   AS user_id,
    product_id AS product_name,
    price, server, status, created_at,
    phone, steamid, username
  FROM orders
  ORDER BY created_at DESC
  LIMIT :lim OFFSET :off
");
$st->bindValue(':lim', $perPage, PDO::PARAM_INT);
$st->bindValue(':off', $offset,  PDO::PARAM_INT);
$st->execute();
$orders = $st->fetchAll();

// Daily report: only approved sum for TOTAL
$start = strtotime('today');
$end   = $start + 86400;
$st = db()->prepare("SELECT 
  COUNT(*) AS cnt,
  SUM(CASE WHEN status='approved' THEN price ELSE 0 END) AS total_approved,
  SUM(CASE WHEN status='approved' THEN 1 ELSE 0 END) AS ok_cnt,
  SUM(CASE WHEN status='pending'  THEN 1 ELSE 0 END) AS pend_cnt,
  SUM(CASE WHEN status='incomplete' THEN 1 ELSE 0 END) AS bad_cnt
FROM orders WHERE created_at>=? AND created_at<?");
$st->execute([$start,$end]);
$rep = $st->fetch() ?: ['cnt'=>0,'total_approved'=>0,'ok_cnt'=>0,'pend_cnt'=>0,'bad_cnt'=>0];

// Members (users count)
$usersCount = (int)(db()->query("SELECT COUNT(*) c FROM users")->fetch()['c'] ?? 0);

function ago($s){
  if(!$s) return '—';
  $m=floor($s/60); $h=floor($m/60); $d=floor($h/24);
  if ($s<60) return $s.' ثانیه پیش';
  if ($m<60) return $m.' دقیقه پیش';
  if ($h<24) return $h.' ساعت پیش';
  return $d.' روز پیش';
}
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>مانیتورینگ FunWorld</title>
<style>
  :root{
    --bg:#0b1220;--card:#0f172a;--muted:#94a3b8;--text:#e5e7eb;
    --line:#1f2937;--accent:#22d3ee;--ok:#22c55e;--bad:#ef4444;--wait:#f59e0b;
  }
  *{box-sizing:border-box}
  body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
  a{color:inherit;text-decoration:none}
  .container{max-width:1100px;margin:0 auto;padding:20px}
  header{display:flex;align-items:center;justify-content:space-between;margin-bottom:18px}
  .brand{display:flex;align-items:center;gap:10px}
  .logo{width:12px;height:12px;border-radius:10px;background:var(--accent);box-shadow:0 0 20px var(--accent)}
  .logout a{font-size:13px;color:#93c5fd}
  .grid{display:grid;grid-template-columns:1fr;gap:16px}
  @media(min-width:920px){ .grid{grid-template-columns:1.2fr 1fr} }
  .card{background:var(--card);border:1px solid var(--line);border-radius:18px;padding:18px}
  .card h3{margin:0 0 12px;font-size:16px}
  .row{display:flex;align-items:center;gap:8px;margin:8px 0;flex-wrap:wrap}
  .badge{display:inline-block;padding:4px 10px;border-radius:999px;font-size:12px;border:1px solid var(--line);white-space:nowrap}
  .b-ok{background:rgba(34,197,94,.15); border-color:rgba(34,197,94,.4); color:#86efac}
  .b-bad{background:rgba(239,68,68,.15); border-color:rgba(239,68,68,.4); color:#fecaca}
  .b-wait{background:rgba(245,158,11,.15); border-color:rgba(245,158,11,.4); color:#fde68a}
  .stat{display:grid;grid-template-columns:repeat(3,1fr);gap:10px;margin-top:10px}
  @media(min-width:920px){ .stat{grid-template-columns:repeat(6,1fr);} }
  .stat .box{background:#0b1220;border:1px dashed var(--line);border-radius:14px;padding:12px;text-align:center}
  .stat .t{font-size:12px;color:var(--muted)}
  .stat .v{font-size:18px;margin-top:6px}
  table{width:100%;border-collapse:separate;border-spacing:0 8px}
  th{color:var(--muted);font-weight:600;font-size:12px;text-align:right;padding:0 8px}
  td{background:#0b1220;border:1px solid var(--line);border-left:none;border-right:none;padding:10px 8px;border-radius:10px;vertical-align:middle}
  .tbl-head{padding-bottom:6px;border-bottom:1px dashed var(--line);margin-bottom:8px}
  .status-cell{display:flex;align-items:center;gap:8px}
  .actions{display:flex;gap:6px}
  .btn{padding:6px 10px;border:1px solid var(--line);background:#0b1220;border-radius:10px;font-size:12px;cursor:pointer}
  .pager{display:flex;gap:6px;justify-content:center;margin-top:10px;flex-wrap:wrap}
  .pager a,.pager span{padding:6px 10px;border:1px solid var(--line);background:#0b1220;border-radius:10px;font-size:13px}
  .pager .active{background:#1d2a44}
  .muted{color:var(--muted)}

  /* Modal */
  .modal{position:fixed;inset:0;background:rgba(0,0,0,.55);display:none;align-items:center;justify-content:center;padding:16px;z-index:1000}
  .modal.open{display:flex}
  .modal-card{width:100%;max-width:540px;background:#0f172a;border:1px solid var(--line);border-radius:16px;padding:16px}
  .modal-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:8px}
  .close{cursor:pointer;border:none;background:#1f2937;color:#e5e7eb;border-radius:10px;padding:6px 10px}
  .dl{display:grid;grid-template-columns:120px 1fr;gap:8px}
  .dl div{padding:6px 8px;border:1px solid var(--line);border-radius:10px;background:#0b1220}
</style>
</head>
<body>
  <div class="container">
    <header>
      <div class="brand">
        <span class="logo"></span>
        <div>
          <div style="font-weight:700">داشبورد مانیتورینگ FunWorld</div>
          <div class="muted" style="font-size:12px">گزارش‌های لحظه‌ای + پشتیبان از DB</div>
        </div>
      </div>
      <div class="logout"><a href="?logout=1">خروج</a></div>
      
      <div class="muted" style="font-size:12px;margin-inline-end:12px">
  سلام، <?=h($AUTH_USER)?> 👋
  <?php if($AUTH_ROLE==='sudo'): ?>
    | <a href="admin-advanced.php?section=admins" style="color:#93c5fd">مدیریت ادمین‌ها</a>
  <?php endif; ?>
  | <a href="admin-advanced.php" style="color:#93c5fd">مدیریت پیشرفته</a>
</div>

    </header>

    <div class="grid">
      <!-- Status / Report -->
      <div class="card">
        <h3>وضعیت ربات</h3>
        <div class="row">
          <?php if ($isOnline): ?>
            <span class="badge b-ok">آنلاین</span>
            <span class="muted">آخرین فعالیت: <?=h(ago($diff))?></span>
          <?php elseif($lastSeen): ?>
            <span class="badge b-bad">آفلاین</span>
            <span class="muted">آخرین فعالیت: <?=h(ago($diff))?></span>
          <?php else: ?>
            <span class="badge b-wait">نامشخص</span>
            <span class="muted">هنوز heartbeat ثبت نشده</span>
          <?php endif; ?>
        </div>
        <div class="row muted" style="font-size:12px">
          شروع: <?= $startAt ? date('Y-m-d H:i', $startAt) : '—' ?> | آخرین: <?= $lastSeen ? date('Y-m-d H:i', $lastSeen) : '—' ?>
        </div>

        <div style="height:12px"></div>
        <h3>گزارش فروش امروز</h3>
        <?php $day = date('Y-m-d'); ?>
        <div class="muted" style="font-size:13px;margin-bottom:6px">📊 گزارش فروش روز <?=$day?></div>
        <div class="stat">
          <div class="box"><div class="t">🧾 تعداد سفارش‌ها</div><div class="v"><?= (int)$rep['cnt'] ?></div></div>
          <div class="box"><div class="t">💰 مجموع فروش تاییدشده</div><div class="v"><?= number_format((int)$rep['total_approved']) ?></div></div>
          <div class="box"><div class="t">✔️ تایید شده</div><div class="v"><?= (int)$rep['ok_cnt'] ?></div></div>
          <div class="box"><div class="t">⏳ در انتظار</div><div class="v"><?= (int)$rep['pend_cnt'] ?></div></div>
          <div class="box"><div class="t">⛔ ناقص</div><div class="v"><?= (int)$rep['bad_cnt'] ?></div></div>
          <div class="box"><div class="t">👥 اعضای ربات</div><div class="v"><?= number_format($usersCount) ?></div></div>
        </div>

        <div style="margin-top:12px">
          <a class="btn" href="orders-manage.php">مدیریت سفارشات</a>
          <a class="btn" href="webapp/support-admin.php">پشتیبانی</a>
        </div>
      </div>

      <!-- Last 5 orders + pager -->
      <div class="card">
        <h3>۵ خرید آخر</h3>
        <div class="tbl-head">
          <table>
            <thead>
              <tr>
                <th>تاریخ</th>
                <th>شماره</th>
                <th>محصول</th>
                <th>مبلغ</th>
                <th>سرور</th>
                <th>وضعیت</th>
                <th>اکشن</th>
              </tr>
            </thead>
          </table>
        </div>
        <table>
          <tbody>
          <?php if(!$orders): ?>
            <tr><td class="muted" style="border-radius:12px;padding:16px">سفارشی یافت نشد.</td></tr>
          <?php else: foreach($orders as $o): 
            $s = $o['status'];
            $cls = $s==='approved'?'b-ok':($s==='pending'?'b-wait':'b-bad');
            $txt = $s==='approved'?'تایید شده':($s==='pending'?'در انتظار':'ناقص');
            $phone = $o['phone'] ?: '—';
            $username = $o['username'] ?: '—';
            $steamid  = $o['steamid'] ?: '—';
            $uid      = $o['user_id'] ?: '—';
            $pname    = $o['product_name'];
            $price    = (int)$o['price'];
            $server   = $o['server'];
            $created  = (int)$o['created_at'];
          ?>
            <tr>
              <td><?= date('m/d H:i', $created) ?></td>
              <td><?= h($phone) ?></td>
              <td><?= h($pname) ?></td>
              <td><?= number_format($price) ?></td>
              <td><?= h($server) ?></td>
              <td><div class="status-cell"><span class="badge <?=$cls?>"><?=$txt?></span></div></td>
              <td class="actions">
                <button class="btn"
                  data-modal="order"
                  data-user-id="<?=h($uid)?>"
                  data-username="<?=h($username)?>"
                  data-phone="<?=h($phone)?>"
                  data-steamid="<?=h($steamid)?>"
                  data-product="<?=h($pname)?>"
                  data-price="<?=number_format($price)?>"
                  data-server="<?=h($server)?>"
                  data-status="<?=h($txt)?>"
                  data-created="<?=date('Y-m-d H:i',$created)?>"
                >مشاهده جزئیات</button>
              </td>
            </tr>
          <?php endforeach; endif; ?>
          </tbody>
        </table>

        <div class="pager">
          <?php
            $base = strtok($_SERVER['REQUEST_URI'],'?');
            for($p=1;$p<=$pages;$p++){
              $active = ($p===$page)?' class="active"':'';
              echo '<a'.$active.' href="'.$base.'?page='.$p.'">'.$p.'</a>';
            }
          ?>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal -->
  <div class="modal" id="modal-order">
    <div class="modal-card">
      <div class="modal-header">
        <div style="font-weight:700">جزئیات سفارش</div>
        <button class="close" data-close>بستن</button>
      </div>
      <div class="dl">
        <div>کاربر</div><div id="m-username">—</div>
        <div>آی‌دی عددی</div><div id="m-userid">—</div>
        <div>شماره</div><div id="m-phone">—</div>
        <div>استیم آیدی</div><div id="m-steamid">—</div>
        <div>محصول</div><div id="m-product">—</div>
        <div>مبلغ</div><div id="m-price">—</div>
        <div>سرور</div><div id="m-server">—</div>
        <div>وضعیت</div><div id="m-status">—</div>
        <div>تاریخ</div><div id="m-created">—</div>
      </div>
    </div>
  </div>

<script>
  const modal = document.getElementById('modal-order');
  const fill = (btn)=>{
    document.getElementById('m-username').textContent = btn.dataset.username || '—';
    document.getElementById('m-userid').textContent   = btn.dataset.userId   || '—';
    document.getElementById('m-phone').textContent    = btn.dataset.phone    || '—';
    document.getElementById('m-steamid').textContent  = btn.dataset.steamid  || '—';
    document.getElementById('m-product').textContent  = btn.dataset.product  || '—';
    document.getElementById('m-price').textContent    = btn.dataset.price    || '—';
    document.getElementById('m-server').textContent   = btn.dataset.server   || '—';
    document.getElementById('m-status').textContent   = btn.dataset.status   || '—';
    document.getElementById('m-created').textContent  = btn.dataset.created  || '—';
  };
  document.addEventListener('click',(e)=>{
    const btn = e.target.closest('[data-modal="order"]');
    if(btn){ fill(btn); modal.classList.add('open'); }
    if(e.target.matches('[data-close]') || e.target===modal){ modal.classList.remove('open'); }
  });
</script>
</body>
</html>
