
<?php
// bot/shopfun/webapp/api.php
session_start();
error_reporting(0);
date_default_timezone_set('Asia/Tehran');

require_once __DIR__.'/../config.php';
require_once __DIR__.'/../db.php';

// ===== Helpers (file JSON) =====
function jload($p,$d=[]){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:$d; }
function jsave($p,$a){ @mkdir(dirname($p),0777,true); @file_put_contents($p,json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }
function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }

// ===== Input =====
$action = $_GET['action'] ?? $_POST['action'] ?? '';
$uid = preg_replace('/\D/','', (string)($_POST['uid'] ?? ''));
if(!$uid){ echo json_encode(['ok'=>false,'error'=>'NO_UID']); exit; }

// مسیرها
$DATA_DIR = realpath(__DIR__.'/..')."/data/$uid";
$AVATAR   = "data/$uid/avatar.jpg";
$USERS    = realpath(__DIR__.'/..').'/users.txt';
$ORDERS_DIR = realpath(__DIR__.'/..').'/orders';
$UO_DIR     = realpath(__DIR__.'/..').'/user_orders';
$SUPPORT_DIR= __DIR__.'/../support/'.$uid;

@mkdir($DATA_DIR,0777,true);
@mkdir($SUPPORT_DIR,0777,true);

header('Content-Type: application/json; charset=utf-8');

// ===== Actions =====
switch($action){


/* ── پروفایل کوتاه (هدر) ───────────────────────────────── */
case 'get_user': {
  $username = @file_get_contents($DATA_DIR.'/username.txt') ?: '';
  $steam    = @file_get_contents($DATA_DIR.'/steamid.txt') ?: '';
  $balance  = (int)@file_get_contents($DATA_DIR.'/price.txt');
  $av = (is_file(__DIR__.'/../'.$AVATAR)) ? ('../'.$AVATAR) : 'https://amirhajian.com/pic/none.png';
  echo json_encode(['ok'=>true,'username'=>$username,'steam'=>$steam,'balance'=>$balance,'avatar'=>$av]);
  
  break;
}
/* — me: برای هدر و پروفایل — */
case 'me': {
  $uid = (string)$UID;
  $dir = __DIR__.'/../data/'.$uid;
  @mkdir($dir,0777,true);
  $coin  = (int)@file_get_contents("$dir/price.txt");
  $steam = trim((string)@file_get_contents("$dir/steamid.txt"));
  $uname = trim((string)@file_get_contents("$dir/username.txt"));
  $av    = (is_file("$dir/avatar.jpg") ? "../data/$uid/avatar.jpg" : "https://amirhajian.com/pic/none.png");
  echo json_encode(['ok'=>true,'id'=>$uid,'username'=>$uname,'steamid'=>$steam,'coin'=>$coin,'avatar'=>$av]); break;
}


/* — لیست سفارش‌های من — */
case 'orders_list': {
  $uid = (string)$UID;
  $items = [];
  foreach (glob($ORDERS_DIR.'/*.json') as $f){
    $j=@json_decode(@file_get_contents($f),true);
    if(!$j || (string)($j['buyer_id']??'')!==$uid) continue;
    $hist[]=[
      'id'=>$j['id'],'time'=>(int)($j['created_at']??filemtime($f)),
      'product'=>$j['product_id']??'-','price'=>(int)($j['price']??0),
      'server'=>$j['server']??'-','status'=>$j['status']??'pending'
    ];
  }
  usort($hist, function($a,$b){ return $b['time'] <=> $a['time']; });
  echo json_encode([
    'ok'=>true,'username'=>$username,'steam'=>$steam,'balance'=>$balance,'avatar'=>$av,
    'history'=>$hist]); break;
}


/* ── ذخیره استیم ───────────────────────────────────────── */
case 'set_steam': {
  $steam= trim((string)($_POST['steam']??''));
  if($steam===''){ echo json_encode(['ok'=>false,'error'=>'EMPTY']); break; }
  @file_put_contents($DATA_DIR.'/steamid.txt',$steam);
  echo json_encode(['ok'=>true]); break;
}

/* ── لیست محصولات از category ──────────────────────────── */
case 'list_products': {
  $base = realpath(__DIR__.'/..').'/category';
  $items=[];
  foreach((array)scandir($base) as $d){
    if($d==='.'||$d==='..') continue;
    if(is_dir("$base/$d")){
      $name=@file_get_contents("$base/$d/name.txt"); if(!$name) $name=$d;
      $price=(int)@file_get_contents("$base/$d/price.txt");
      $items[]=['code'=>$d,'name'=>$name,'price'=>$price];
    }
  }
  echo json_encode(['ok'=>true,'items'=>$items]); break;
}

/* ── پرداخت از کیف پول ─────────────────────────────────── */
case 'pay_wallet': {
  $pid = $_POST['pid']??''; $servers=$_POST['servers']??''; $price=(int)($_POST['price']??0);
  if(!$pid || $price<=0){ echo json_encode(['ok'=>false,'error'=>'BAD_INPUT']); break; }
  $coin = (int)@file_get_contents($DATA_DIR.'/price.txt');
  if($coin<$price){ echo json_encode(['ok'=>false,'error'=>'BALANCE_LOW']); break; }

  // کم‌کردن موجودی
  $new=$coin-$price; @file_put_contents($DATA_DIR.'/price.txt',$new);

  // نام محصول
  $pdir = realpath(__DIR__.'/..')."/category/$pid";
  $pname = @file_get_contents($pdir.'/name.txt'); if(!$pname) $pname=$pid;

  // سفارش فایل‌محور (همگن با ربات)
  $oid = $uid."_".$pid."_".time();
  $steam = trim((string)@file_get_contents($DATA_DIR.'/steamid.txt')) ?: '-';
  $phone = trim((string)@file_get_contents($DATA_DIR.'/phone.txt')) ?: '-';
  $uname = trim((string)@file_get_contents($DATA_DIR.'/username.txt')) ?: '-';
  $order = [
    'id'=>$oid,'created_at'=>time(),'expires_at'=>time()+30*86400,'status'=>'pending',
    'buyer_id'=>$uid,'buyer_chat'=>$uid,
    'product_id'=>$pname,'product_code'=>$pid,'price'=>$price,
    'steamid'=>$steam,'phone'=>$phone,'username'=>$uname,'server'=>$servers
  ];
  @file_put_contents($ORDERS_DIR."/$oid.json", json_encode($order,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));

  // history append
  $uo = jload($UO_DIR."/$uid.json",[]);
  $uo[]=['id'=>$oid,'time'=>time(),'product'=>$pname,'price'=>$price,'server'=>$servers,'status'=>'pending'];
  jsave($UO_DIR."/$uid.json",$uo);

  echo json_encode(['ok'=>true,'balance'=>$new]); break;
}

/* — خرید: لینک پرداخت آنلاین — */
case 'pay_online':
case 'buy_link': {
  $pid = trim((string)($_POST['pid']??''));
  $servers = trim((string)($_POST['servers']??'')); // '1', '2' یا '1,2'
  if(!$pid){ echo json_encode(['ok'=>false]); break; }
  // قیمت پایه
  $p = realpath(__DIR__."/../category/$pid/price.txt");
  if(!$p || !is_file($p)){ echo json_encode(['ok'=>false]); break; }
  $price = (int)trim(@file_get_contents($p));
  // اگر هر دو سرور
  if ($servers==='1,2' || $servers==='2,1' || $servers==='1+2') $price *= 2;

  $url = "../pay.php?pay=".$price."&from=".$uid."&pid=".$pid."&srv=".urlencode($servers)."&as=webapp";
  echo json_encode(['ok'=>true,'url'=>$url]); break;
}


/* — شارژ کیف پول: لینک درگاه — */
case 'charge_link': {
  $amount = (int)($_POST['amount']??0);
  if($amount<10000){ echo json_encode(['ok'=>false]); break; }
  $url = "../pay.php?pay=".$amount."&from=".$UID."&as=webapp";
  echo json_encode(['ok'=>true,'url'=>$url]); break;
}



/* — پشتیبانی: لود پیام‌ها (after) — */
case 'support_load': {
  $after = (int)($_POST['after']??0);
  $db = jload($SUPPORT_DIR.'/messages.json',[]);
  $out = array_values(array_filter($db, function($m) use($after){
    return (int)$m['id'] > $after;
  }));
  echo json_encode(['ok'=>true,'items'=>$out]); break;
}

/* — پشتیبانی: ارسال متن از کاربر — */
case 'support_send': {
  $text = trim((string)($_POST['text']??''));
  if($text===''){ echo json_encode(['ok'=>false]); break; }
  $db = jload($SUPPORT_DIR.'/messages.json',[]);
  $id = (count($db)>0 ? (int)end($db)['id'] : 0) + 1;
  $db[] = ['id'=>$id,'ts'=>time(),'from'=>'user','type'=>'text','text'=>$text];
  jsave($SUPPORT_DIR.'/messages.json',$db);
  echo json_encode(['ok'=>true]); break;
}

/* — پشتیبانی: آپلود فایل (عکس/صوت) — */
case 'support_send_file': {
  if(empty($_FILES['file'])){ echo json_encode(['ok'=>false]); break; }
  @mkdir(__DIR__.'/uploads',0777,true);
  $ext  = strtolower(pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION));
  $type = (strpos($_FILES['file']['type'],'audio')!==false?'audio':'image');
  $name = $UID.'_'.time().'.'.$ext;
  $dst  = __DIR__.'/uploads/'.$name;
  if(move_uploaded_file($_FILES['file']['tmp_name'],$dst)){
    $url = 'uploads/'.$name;
    $db = jload($SUPPORT_DIR.'/messages.json',[]);
    $id = (count($db)>0 ? (int)end($db)['id'] : 0) + 1;
    $db[]=['id'=>$id,'ts'=>time(),'from'=>'user','type'=>$type,'url'=>$url];
    jsave($SUPPORT_DIR.'/messages.json',$db);
    echo json_encode(['ok'=>true,'url'=>$url]); break;
  } else echo json_encode(['ok'=>false]); break;
}


default: echo json_encode(['ok'=>false,'error'=>'UNKNOWN_ACTION']);
}
