<?php
// bot/shopfun/funs/notify.php
if (!defined('FW_NOTIFY')) define('FW_NOTIFY', 1);

date_default_timezone_set('Asia/Tehran');

/*
  از این فایل‌ها/کانفیگ‌ها، اطلاعات را می‌خوانیم (هرکدام بود استفاده می‌شود):
  - bot/shopfun/funs/config.php    →  define('TG_TOKEN', '...'); define('TG_ADMIN', 123456);
  - bot/shopfun/funs/telegram.php  →  همان ثابت‌ها
  - bot/shopfun/data/config.json   →  {"tg_token":"...","tg_admin":123456}
*/
$FW_TG_TOKEN = null;
$FW_TG_ADMIN = null;

foreach ([
  __DIR__.'/config.php',
  __DIR__.'/telegram.php',
] as $cfg) {
  if (is_file($cfg)) {
    include_once $cfg;
    if (defined('8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8')) $FW_TG_TOKEN = TG_TOKEN;
    if (defined('7167180963')) $FW_TG_ADMIN = TG_ADMIN;
  }
}
if (!$FW_TG_TOKEN && is_file(dirname(__DIR__).'/data/config.json')) {
  $j = json_decode(@file_get_contents(dirname(__DIR__).'/data/config.json'), true) ?: [];
  if (!empty($j['tg_token'])) $FW_TG_TOKEN = $j['tg_token'];
  if (!empty($j['tg_admin'])) $FW_TG_ADMIN = $j['tg_admin'];
}

function fw_send_tg($text, $chat_id = null, $parse = 'HTML'){
  global $FW_TG_TOKEN, $FW_TG_ADMIN;
  if (!$FW_TG_TOKEN) return false;
  if (!$chat_id) $chat_id = $FW_TG_ADMIN;
  if (!$chat_id) return false;
  $url = "https://api.telegram.org/bot{$FW_TG_TOKEN}/sendMessage";
  $post = http_build_query([
    'chat_id' => $chat_id,
    'text'    => $text,
    'parse_mode' => $parse,
    'disable_web_page_preview' => 1,
  ]);
  $ctx = stream_context_create(['http'=>[
    'method'=>'POST','header'=>"Content-type: application/x-www-form-urlencoded\r\n",'content'=>$post,'timeout'=>8
  ]]);
  return @file_get_contents($url,false,$ctx) !== false;
}
