<?php
// funs/auth.php
if (session_status()===PHP_SESSION_NONE) session_start();

define('FUNS_DIR', __DIR__);
define('ADMINS_DIR', FUNS_DIR.'/admins');
define('SUDO_FILE',  FUNS_DIR.'/sudo.txt');
@mkdir(ADMINS_DIR,0777,true);

/* ---------- creds loaders ---------- */
function _sudo_creds(){
  $u=''; $p='';
  if(is_file(SUDO_FILE)){
    $t=trim(@file_get_contents(SUDO_FILE));
    if(strpos($t,':')!==false){ list($u,$p)=array_map('trim',explode(':',$t,2)); }
    else{
      $lines=preg_split('/\r?\n/u',$t);
      $u=trim($lines[0]??''); $p=trim($lines[1]??'');
    }
  }
  return [$u,$p];
}
function _admin_path($user){ return ADMINS_DIR.'/'.preg_replace('/[^A-Za-z0-9_.-]/','_',$user).'.txt'; }
function admin_exists($user){ return is_file(_admin_path($user)); }
function admin_get($user){
  $f=_admin_path($user); if(!is_file($f)) return null;
  $t=@file_get_contents($f);
  $j=@json_decode($t,true);
  if(is_array($j) && isset($j['password'])) return $j;
  // قدیمی/ساده: فقط رمز داخل فایل
  return ['username'=>$user,'password'=>trim($t)];
}
function admin_save($user,$pass){
  $f=_admin_path($user);
  $data=['username'=>$user,'password'=>password_hash($pass,PASSWORD_BCRYPT)];
  @file_put_contents($f,json_encode($data,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
}
function admins_list(){
  $out=[]; foreach((array)glob(ADMINS_DIR.'/*.txt') as $f){
    $u=basename($f,'.txt'); $out[]=$u;
  } return $out;
}

/* ---------- auth helpers ---------- */
function auth_user(){ return $_SESSION['auth_user'] ?? null; }
function auth_role(){ return $_SESSION['auth_role'] ?? null; }
function is_sudo(){ return auth_role()==='sudo'; }

/* ---------- login gate ---------- */
function auth_gate($return_to='admin-monitor.php'){
  if(isset($_GET['logout'])){
    session_destroy(); header('Location: '.$return_to); exit;
  }
  if(!empty($_SESSION['auth_user'])) return; // already authed

  $err='';
  if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['u'],$_POST['p'])){
    $u=trim($_POST['u']); $p=(string)$_POST['p'];
    // sudo
    list($su,$sp)=_sudo_creds();
    if($su!=='' && $u===$su && $p===$sp){
      $_SESSION['auth_user']=$u; $_SESSION['auth_role']='sudo';
      header('Location: '.$return_to); exit;
    }
    // admins
    if(admin_exists($u)){
      $row=admin_get($u); $ok=false;
      if(password_get_info($row['password'])['algo']>0) $ok=password_verify($p,$row['password']);
      else $ok = ($p===$row['password']); // fallback ساده
      if($ok){
        $_SESSION['auth_user']=$u; $_SESSION['auth_role']='admin';
        header('Location: '.$return_to); exit;
      }
    }
    $err='نام کاربری یا رمز اشتباه است.';
  }

  // login ui
  echo '<!doctype html><html lang="fa" dir="rtl"><head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1" />
  <title>ورود | FunWorld</title>
  <style>
    body{margin:0;background:#0f172a;color:#e2e8f0;font-family:IRANSans,Segoe UI,Tahoma,Arial}
    .wrap{min-height:100vh;display:flex;align-items:center;justify-content:center;padding:24px}
    .card{width:100%;max-width:380px;background:#111827;border:1px solid #1f2937;border-radius:18px;padding:24px;box-shadow:0 10px 30px rgba(0,0,0,.45)}
    h1{margin:0 0 16px;font-size:20px}
    label{display:block;font-size:14px;margin-bottom:8px;color:#94a3b8}
    input{width:100%;padding:12px 14px;border-radius:12px;border:1px solid #374151;background:#0b1220;color:#e5e7eb;outline:none;margin-bottom:10px}
    input:focus{border-color:#60a5fa;box-shadow:0 0 0 3px rgba(96,165,250,.2)}
    button{width:100%;padding:12px 14px;background:#2563eb;border:none;border-radius:12px;color:#fff;font-weight:600;cursor:pointer}
    .err{margin-top:10px;color:#fca5a5;font-size:13px}
  </style></head><body><div class="wrap">
    <form class="card" method="post">
      <h1>ورود به پنل</h1>
      <label>نام کاربری</label>
      <input name="u" placeholder="یوزر نیمتو بپاش رو سرو صورتمون مشتی">
      <label>رمز عبور</label>
      <input name="p" type="password" placeholder="••••••••">
      <button type="submit">ورود</button>'.
      ($err?'<div class="err">'.$err.'</div>':'').'
    </form></div></body></html>'; exit;
}

/* ---------- admin management actions (for sudo) ---------- */
function sudo_add_admin($user,$pass){
  if($user==='') return 'نام خالی است';
  if(admin_exists($user)) return 'این یوزر وجود دارد';
  admin_save($user,$pass); return 'ثبت شد';
}
function sudo_del_admins($users){
  $n=0; foreach((array)$users as $u){
    $f=_admin_path($u); if(is_file($f)){ @unlink($f); $n++; }
  } return $n.' کاربر حذف شد';
}
function admin_change_pass($user,$old,$new){
  if(is_sudo() && $user===auth_user()){ // sudo می‌تونه برای خودش عوض کنه (بدون old)
    admin_save($user,$new); return 'رمز بروزرسانی شد';
  }
  if(!admin_exists($user)) return 'کاربر نیست';
  $row=admin_get($user);
  $ok = password_get_info($row['password'])['algo']>0 ? password_verify($old,$row['password']) : ($old===$row['password']);
  if(!$ok) return 'رمز فعلی اشتباه است';
  admin_save($user,$new); return 'رمز بروزرسانی شد';
}
