<?php
require_once __DIR__.'/config.php';

class DB {
  private static $pdo = null;
  public static function pdo(){
    if (!self::$pdo) {
      $dsn = 'mysql:host='.DB_HOST.';dbname='.DB_NAME.';charset=utf8mb4';
      self::$pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      ]);
    }
    return self::$pdo;
  }
}

/* ---------- USERS ---------- */
function db_user_get($id){
  $pdo = DB::pdo();
  $st = $pdo->prepare("SELECT * FROM users WHERE id=?");
  $st->execute([$id]);
  $row = $st->fetch();
  if(!$row){
    $now=time();
    $pdo->prepare("INSERT INTO users (id,price,step,created_at,updated_at) VALUES (?,?,?,?,?)")
        ->execute([$id,0,'none',$now,$now]);
    $st->execute([$id]);
    $row=$st->fetch();
  }
  return $row;
}
function db_user_update($id, array $fields){
  if(empty($fields)) return;
  $pdo = DB::pdo();
  $fields['updated_at'] = time();
  $cols = array_keys($fields);

  // به‌جای Arrow Function از کلوزر معمولی استفاده می‌کنیم
  $setParts = array_map(function($c){ return "$c=?"; }, $cols);
  $sql  = "UPDATE users SET ".implode(',', $setParts)." WHERE id=?";

  $vals = array_values($fields);
  $vals[] = $id;

  $pdo->prepare($sql)->execute($vals);
}


/* ---------- ORDERS ---------- */
function db_order_add(array $o){
  $pdo = DB::pdo();
  $pdo->prepare("INSERT INTO orders
    (id,buyer_id,buyer_chat,product_id,product_code,price,steamid,phone,username,server,status,created_at,expires_at)
    VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)")->execute([
      $o['id'],$o['buyer_id'],$o['buyer_chat'],$o['product_id'],$o['product_code'],$o['price'],
      $o['steamid'],$o['phone'],$o['username'],$o['server'],$o['status'],$o['created_at'],$o['expires_at']
    ]);
}
function db_order_set_status($id,$status){
  DB::pdo()->prepare("UPDATE orders SET status=? WHERE id=?")->execute([$status,$id]);
}

/* ---------- DISCOUNTS ---------- */
function db_discount_get($code){
  $st = DB::pdo()->prepare("SELECT * FROM discount_codes WHERE code=?");
  $st->execute([$code]);
  return $st->fetch();
}
function db_discount_inc_use($code){
  DB::pdo()->prepare("UPDATE discount_codes SET uses=uses+1 WHERE code=?")->execute([$code]);
}
