<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors',1);
date_default_timezone_set('Asia/Tehran');

require_once __DIR__.'/funs/auth.php';
auth_gate('admin-advanced.php');

define('DISCOUNT_DB', __DIR__.'/discounts/codes.json');
@mkdir(dirname(DISCOUNT_DB),0777,true);
if(!is_file(DISCOUNT_DB)) @file_put_contents(DISCOUNT_DB,'{}');

if(!defined('BOT_TOKEN')) define('BOT_TOKEN','8051610396:AAGtHNbK8Qymym_llZ4uv7r5DenWF1wlHJ8');
if(!defined('TELEGRAM_ADMIN_CHAT')) define('TELEGRAM_ADMIN_CHAT',7167180963);

function tg_send($chat,$text){
  @file_get_contents("https://api.telegram.org/bot".BOT_TOKEN."/sendMessage?chat_id=$chat&parse_mode=HTML&text=".urlencode($text));
}
function h($s){ return htmlspecialchars((string)$s,ENT_QUOTES,'UTF-8'); }
function jload($p){ $j=@json_decode(@file_get_contents($p),true); return is_array($j)?$j:[]; }
function jsave($p,$a){ @file_put_contents($p,json_encode($a,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT)); }

/* ---------- actions ---------- */
$flash='';

/* discounts: add */
if(isset($_POST['act']) && $_POST['act']==='disc_add'){
  $code=strtoupper(trim($_POST['code']??'')); $p=(int)($_POST['percent']??0); $days=(int)($_POST['days']??0);
  if($code!=='' && $p>0 && $p<=90){
    $db=jload(DISCOUNT_DB);
    $db[$code]=[
      'percent'=>$p,
      'expire_at'=>$days>0? time()+$days*86400 : 0,
      'is_active'=>true,
      'created_at'=>time(),
      'uses'=>0,
      'servers'=>['1','2','1+2']
    ];
    jsave(DISCOUNT_DB,$db);
    $flash="کد ثبت شد: $code";
    tg_send(TELEGRAM_ADMIN_CHAT,"🎟 <b>کد تخفیف جدید</b>\nکد: <code>$code</code>\nدرصد: <b>$p%</b>\nتوسط: <b>".h(auth_user())."</b>");
  } else $flash='ورودی نامعتبر';
}
/* discounts: delete */
if(isset($_POST['act']) && $_POST['act']==='disc_del'){
  $db=jload(DISCOUNT_DB); $sel=(array)($_POST['sel']??[]); $n=0;
  foreach($sel as $c){ if(isset($db[$c])){ unset($db[$c]); $n++; } }
  jsave(DISCOUNT_DB,$db);
  if($n) tg_send(TELEGRAM_ADMIN_CHAT,"🧹 حذف کد تخفیف: <b>$n</b> عدد — توسط <b>".h(auth_user())."</b>");
  $flash="$n کد حذف شد";
}
/* sudo: add admin */
if(isset($_POST['act']) && $_POST['act']==='admin_add' && is_sudo()){
  $flash = sudo_add_admin(trim($_POST['u']??''), trim($_POST['p']??''));
}
/* sudo: delete admins */
if(isset($_POST['act']) && $_POST['act']==='admin_del' && is_sudo()){
  $flash = sudo_del_admins($_POST['sel']??[]);
}
/* my password */
if(isset($_POST['act']) && $_POST['act']==='change_pass'){
  $flash = admin_change_pass(auth_user(), trim($_POST['old']??''), trim($_POST['new']??''));
}

/* users (file-based) */
$users=[]; $users_file=__DIR__.'/users.txt';
if(is_file($users_file)){
  foreach(preg_split('/\r?\n/',trim(@file_get_contents($users_file))) as $uid){
    $uid=trim($uid); if($uid==='') continue;
    $dir=__DIR__."/data/$uid";
    $users[]=[
      'id'=>$uid,
      'phone'=>@file_get_contents("$dir/phone.txt") ?: '',
      'steam'=>@file_get_contents("$dir/steamid.txt") ?: '',
      'username'=>@file_get_contents("$dir/username.txt") ?: '',
      'coin'=>(int)@file_get_contents("$dir/price.txt"),
    ];
  }
}

/* search */
$Q=trim($_GET['q']??''); $by=$_GET['by']??'';
if($Q!==''){
  $users=array_values(array_filter($users,function($u) use($by,$Q){
    if($by==='id')     return (string)$u['id']===$Q;
    if($by==='phone')  return strpos($u['phone'],$Q)!==false;
    if($by==='steam')  return strpos($u['steam'],$Q)!==false;
    if($by==='uname')  return $u['username']!=='' && stripos($u['username'],$Q)!==false;
    return false;
  }));
}

/* wallet */
if(isset($_POST['act']) && $_POST['act']==='wallet'){
  $uid=trim($_POST['uid']??''); $delta=(int)($_POST['delta']??0);
  $f=__DIR__."/data/$uid/price.txt"; $cur=(int)@file_get_contents($f);
  $new=max(0,$cur+$delta); @file_put_contents($f,$new);
  $flash="موجودی جدید: ".number_format($new);
  tg_send($uid,"💼 تغییر موجودی کیف پول\nمقدار: <b>".number_format(abs($delta))."</b> تومان ".($delta>=0? "افزوده شد" : "کسر شد")."\nموجودی فعلی: <b>".number_format($new)."</b>");
  tg_send(TELEGRAM_ADMIN_CHAT,"💼 مدیریت کیف پول\nکاربر: <code>$uid</code>\nتغییر: <b>".number_format($delta)."</b>\nتوسط: <b>".h(auth_user())."</b>");
}

/* order update from user modal */
if(isset($_POST['act']) && $_POST['act']==='order_update'){
  $oid=basename($_POST['oid']??''); $status=$_POST['status']??'';
  $f=__DIR__."/orders/$oid.json";
  if(is_file($f) && in_array($status,['approved','incomplete'],true)){
    $d=@json_decode(@file_get_contents($f),true);
    if($d){
      $d['status']=$status;
      @file_put_contents($f,json_encode($d,JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT));
      $flash='وضعیت سفارش بروز شد';
      // notify user + admin
      $uid=$d['buyer_id']??'';
      $human = $status==='approved'?'✅ تایید شد':'⛔ ناقص شد';
      tg_send($uid,"🧾 وضعیت سفارش شما <b>{$human}</b>\nمحصول: <b>".h($d['product_id']??'-')."</b>\nسرور: <b>".h($d['server']??'-')."</b>");
      tg_send(TELEGRAM_ADMIN_CHAT,"🧾 تغییر وضعیت سفارش\nOID: <code>$oid</code>\nوضعیت: <b>$human</b>\nتوسط: <b>".h(auth_user())."</b>");
    }
  }
  header("Location: admin-advanced.php?section=users"); exit;
}

$codes = jload(DISCOUNT_DB);
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1" />
<title>مدیریت پیشرفته | FunWorld</title>
<style>
  :root{--bg:#0b1220;--card:#0f172a;--muted:#94a3b8;--text:#e5e7eb;--line:#1f2937;--accent:#22d3ee;--ok:#22c55e;--bad:#ef4444;}
  body{margin:0;background:var(--bg);color:var(--text);font-family:IRANSans,Segoe UI,Tahoma,Arial}
  .wrap{display:flex;min-height:100vh}
  .side{width:240px;background:#0f172a;border-inline-end:1px solid var(--line);padding:14px;position:sticky;top:0;height:100vh}
  .side .hi{margin-bottom:12px;color:#94a3b8}
  .btn{display:block;width:100%;text-align:right;padding:10px 12px;border:1px solid var(--line);border-radius:12px;background:#0b1220;margin-bottom:8px;cursor:pointer;color:#e5e7eb;transition:.2s}
  .btn:hover{background:#1d2a44;transform:translateY(-1px)}
  .btn.danger{background:#7f1d1d}
  .main{flex:1;padding:16px}
  .card{background:#0f172a;border:1px solid var(--line);border-radius:18px;padding:16px;margin-bottom:14px}
  .muted{color:var(--muted)}
  table{width:100%;border-collapse:separate;border-spacing:0 8px}
  th{color:var(--muted);font-size:12px;text-align:right}
  td{background:#0b1220;border:1px solid var(--line);padding:8px;border-radius:10px;vertical-align:middle}
  .row{display:flex;gap:8px;flex-wrap:wrap}
  input,select{padding:8px 10px;border-radius:10px;border:1px solid var(--line);background:#0b1220;color:#e5e7eb}
  .flash{position:fixed;top:18px;left:50%;transform:translateX(-50%);background:#1d2a44;border:1px solid var(--line);border-radius:12px;padding:10px 16px;z-index:1000}
  .hero{display:flex;align-items:center;justify-content:center;height:calc(100vh - 40px);flex-direction:column;opacity:.8}
  .hero h1{margin:0 0 8px}
  /* modal */
  .modal{position:fixed;inset:0;background:rgba(0,0,0,.55);display:none;align-items:center;justify-content:center;padding:16px;z-index:2000}
  .modal.open{display:flex}
  .modal-card{width:100%;max-width:720px;background:#0f172a;border:1px solid var(--line);border-radius:16px;padding:14px}
  .modal-header{display:flex;align-items:center;justify-content:space-between;margin-bottom:10px}
  .close{cursor:pointer;border:none;background:#1f2937;color:#e5e7eb;border-radius:10px;padding:6px 10px}
  .tabs{display:flex;gap:6px;margin-bottom:10px}
  .tab{padding:8px 12px;border:1px solid var(--line);background:#0b1220;border-radius:10px;cursor:pointer}
  .tab.active{background:#1d2a44}
  .hidden{display:none}
  .avatar{width:36px;height:36px;border-radius:999px;object-fit:cover;border:1px solid #263244;background:#111827}
  .pill{padding:4px 10px;border-radius:999px;border:1px solid var(--line);font-size:12px}
  .b-ok{background:rgba(34,197,94,.15);color:#86efac}
  .b-wait{background:#3b2e10;color:#fde68a}
  .b-bad{background:rgba(239,68,68,.15);color:#fecaca}
  .btn.sel{background:#1d2a44;outline:2px solid #1d2a44}
 .nice-scroll{max-height:240px;overflow:auto;border-radius:12px}
.nice-scroll::-webkit-scrollbar{width:10px}
.nice-scroll::-webkit-scrollbar-track{background:#0b1220;border:1px solid var(--line);border-radius:10px}
.nice-scroll::-webkit-scrollbar-thumb{background:#1d2a44;border-radius:10px}
.nice-scroll::-webkit-scrollbar-thumb:hover{background:#2a3b5f}

</style>
</head>
<body>
<div class="wrap">
  <aside class="side">
    <div class="hi">سلام، <?=h(auth_user())?> 👋</div>
    <?php if(is_sudo()): ?>
      <button class="btn" onclick="openBox('admins')">مدیریت ادمین‌ها</button>
    <?php endif; ?>
    <button class="btn" onclick="openDiscounts()">کد تخفیف</button>
    <button class="btn" onclick="openBox('users')">مدیریت کاربران</button>
    <form method="post" style="margin-top:10px">
      <input type="hidden" name="act" value="change_pass">
      <div class="muted" style="margin:6px 0">تغییر رمز شما</div>
      <input name="old" type="password" placeholder="رمز فعلی">
      <input name="new" type="password" placeholder="رمز جدید" style="margin-top:6px">
      <button class="btn" type="submit" style="margin-top:6px">تغییر رمز</button>
    </form>
    <a class="btn" href="admin-monitor.php">⟵ مانیتورینگ</a>
  </aside>

  <main class="main">
    <?php if($flash): ?><div class="flash"><?=h($flash)?></div><?php endif; ?>

    <!-- صفحه شروع خالی -->
    <div id="welcome" class="hero">
      <h1>به بخش پیشرفته خوش اومدی <?=h(auth_user())?> ✨</h1>
      <div class="muted">از منوی کنار یکی از بخش‌ها را انتخاب کن.</div>
    </div>

    <!-- ادمین‌ها -->
    <div id="box-admins" class="card hidden">
      <h3>مدیریت ادمین‌ها (فقط sudo)</h3>
      <?php if(!is_sudo()){ echo '<div class="muted">دسترسی ندارید.</div>'; } else { ?>
      <div class="row">
        <form method="post" class="card" style="flex:1;min-width:260px">
          <input type="hidden" name="act" value="admin_add">
          <div class="muted">افزودن ادمین</div>
          <input name="u" placeholder="username" required>
          <input name="p" placeholder="password" required>
          <button class="btn" type="submit" style="margin-top:6px">افزودن</button>
        </form>
        <form method="post" class="card" style="flex:1;min-width:260px">
          <input type="hidden" name="act" value="admin_del">
          <div class="muted">حذف ادمین</div>
          <div style="max-height:220px;overflow:auto">
            <?php foreach(admins_list() as $u): ?>
              <label style="display:block;margin:6px 0">
                <input type="checkbox" name="sel[]" value="<?=h($u)?>"> <?=h($u)?>
              </label>
            <?php endforeach; ?>
          </div>
          <button class="btn danger" type="submit">حذف کاربر</button>
        </form>
      </div>
      <?php } ?>
    </div>

    <!-- کاربران -->
    <div id="box-users" class="card hidden">
      <h3>مدیریت کاربران</h3>

      <!-- نوار جستجو از طریق -->
      <div class="card" style="margin-bottom:10px">
        <div class="muted" style="margin-bottom:8px">جستجو از طریق:</div>
        <div class="row" id="search-chooser">
          <button class="btn" data-by="id"    type="button">ایدی عددی</button>
          <button class="btn" data-by="phone" type="button">شماره</button>
          <button class="btn" data-by="steam" type="button">استیم آیدی</button>
          <button class="btn" data-by="uname" type="button">یوزرنیم</button>
        </div>
        <form method="get" class="row" id="search-form" style="margin-top:8px">
          <input type="hidden" name="section" value="users">
          <input type="hidden" name="by" id="by" value="<?=h($by)?>">
          <input name="q" id="q" value="<?=h($Q)?>" placeholder="عبارت جستجو…">
          <button class="btn" type="submit">جستجو</button>
        </form>
      </div>

      <table>
        <thead><tr><th>کاربر</th><th>شماره</th><th>استیم</th><th>موجودی</th><th>اکشن</th></tr></thead>
        <tbody>
        <?php if(!$users){ echo '<tr><td>—</td></tr>'; } else foreach($users as $u): 
          $avatar = "data/{$u['id']}/avatar.jpg";
  $has = is_file(__DIR__."/$avatar");
  $avatarSrc = $has ? $avatar : 'https://amirhajian.com/pic/none.png';
        ?>
        <img class="avatar zoomable" src="<?=$avatarSrc?>" alt="" data-full="<?=$avatarSrc?>">
          <tr>
            <td>
              <div class="row" style="align-items:center;gap:8px">
                <img class="avatar" src="<?= $has? $avatar : 'https://via.placeholder.com/72x72?text=%20' ?>" alt="">
                <div>#<?=h($u['id'])?> <div class="muted" style="font-size:12px">@<?=h($u['username']?:'—')?></div></div>
              </div>
            </td>
            <td><?=h($u['phone']?:'—')?></td>
            <td><?=h($u['steam']?:'—')?></td>
            <td><?=number_format($u['coin'])?></td>
            <td>
              <button class="btn" 
                data-modal="user" 
                data-uid="<?=h($u['id'])?>" 
                data-phone="<?=h($u['phone'])?>" 
                data-steam="<?=h($u['steam'])?>" 
                data-uname="<?=h($u['username'])?>" 
                data-coin="<?= (int)$u['coin'] ?>"
              >جزئیات</button>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>

  </main>
</div>
<!-- مودال آواتار -->
<div class="modal" id="modal-avatar">
  <div class="modal-card" style="max-width:420px;text-align:center;background:transparent;border:none;box-shadow:none">
    <button class="close" data-close style="margin-bottom:10px">بستن</button>
    <img id="big-avatar" src="" alt="" style="width:280px;height:280px;border-radius:999px;object-fit:cover;border:2px solid #1f2937;box-shadow:0 0 30px rgba(0,0,0,.4)">
  </div>
</div>

<!-- مودال: کد تخفیف -->
<div class="modal" id="modal-discount">
  <div class="modal-card">
    <div class="modal-header">
      <div style="font-weight:700">کد تخفیف</div>
      <button class="close" data-close>بستن</button>
    </div>
    <div class="tabs">
      <button class="tab active" data-tab="d-add">افزودن</button>
      <button class="tab" data-tab="d-del">حذف</button>
      <button class="tab" data-tab="d-list">لیست</button>
    </div>

    <div id="d-add">
      <form method="post" class="row">
        <input type="hidden" name="act" value="disc_add">
        <input name="code" placeholder="FUN30" required>
        <input name="percent" type="number" min="1" max="90" placeholder="درصد (1-90)" required>
        <input name="days" type="number" min="0" placeholder="روز اعتبار (0=نامحدود)" required>
        <button class="btn" type="submit">ثبت کد</button>
      </form>
    </div>

    <div id="d-del" class="hidden">
      <form method="post">
        <input type="hidden" name="act" value="disc_del">
        <div style="max-height:260px;overflow:auto;margin:8px 0">
          <?php foreach($codes as $c=>$r): ?>
            <label style="display:block;margin:6px 0">
              <input type="checkbox" name="sel[]" value="<?=h($c)?>"> <?=h($c)?> — ٪<?=$r['percent']?>
            </label>
          <?php endforeach; ?>
        </div>
        <button class="btn danger" type="submit">حذف انتخاب‌شده‌ها</button>
      </form>
    </div>

    <div id="d-list" class="hidden">
      <table>
        <thead><tr><th>کد</th><th>٪</th><th>اعتبار</th><th>استفاده</th></tr></thead>
        <tbody>
        <?php if(!$codes){ echo '<tr><td>—</td></tr>'; } else {
          foreach($codes as $c=>$r){
            $exp = $r['expire_at']? date('Y-m-d',$r['expire_at']) : 'نامحدود';
            echo "<tr><td>".h($c)."</td><td>{$r['percent']}</td><td>{$exp}</td><td>".(int)$r['uses']."</td></tr>";
          }
        } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- مودال: جزئیات کاربر -->
<div class="modal" id="modal-user">
  <div class="modal-card">
    <div class="modal-header">
      <div style="font-weight:700">جزئیات کاربر</div>
      <button class="close" data-close>بستن</button>
    </div>
    <div id="user-info" class="row" style="align-items:center;margin-bottom:10px"></div>
    <div class="card" style="margin-bottom:10px">
      <div class="muted" style="margin-bottom:6px">مدیریت کیف پول</div>
      <form method="post" class="row" style="align-items:center">
        <input type="hidden" name="act" value="wallet">
        <input type="hidden" name="uid" id="w-uid" value="">
        <div class="pill">موجودی: <span id="w-coin">0</span></div>
        <input name="delta" type="number" placeholder="+10000 / -5000">
        <button class="btn" type="submit">اعمال</button>
      </form>
    </div>
    <div class="row">
      <div class="card" style="flex:1;min-width:260px">
        <div class="muted" style="margin-bottom:6px">هیستوری خرید</div>
        <div id="hist" class="nice-scroll">—</div>
      </div>
      <div class="card" style="flex:1;min-width:260px">
        <div class="muted" style="margin-bottom:6px">خریدهای در انتظار</div>
        <div id="pend" class="nice-scroll">—</div>
      </div>
    </div>
  </div>
</div>

<script>
/* open sections */
function openBox(id){
  document.getElementById('welcome').classList.add('hidden');
  ['admins','users'].forEach(x=>{
    const el=document.getElementById('box-'+x);
    if(el) el.classList.toggle('hidden', x!==id);
  });
}
function openDiscounts(){
  document.getElementById('welcome').classList.add('hidden');
  document.getElementById('modal-discount').classList.add('open');
}

/* discount tabs */
document.addEventListener('click',e=>{
  if(e.target.matches('.tab')){
    const tab=e.target.dataset.tab;
    document.querySelectorAll('.tab').forEach(t=>t.classList.remove('active'));
    e.target.classList.add('active');
    ['d-add','d-del','d-list'].forEach(id=>{
      document.getElementById(id).classList.toggle('hidden', id!==tab);
    });
  }
  if(e.target.matches('[data-close]')){
    e.target.closest('.modal').classList.remove('open');
  }
});

/* search chooser */
/* search chooser (active state + مقدار by) */
const chooser = document.getElementById('search-chooser');
const byInput = document.getElementById('by');

chooser?.addEventListener('click', e=>{
  const b=e.target.closest('button[data-by]'); if(!b) return;
  // فعال‌سازی ظاهری
  chooser.querySelectorAll('button[data-by]').forEach(x=>x.classList.remove('sel'));
  b.classList.add('sel');
  // ست کردن مقدار
  byInput.value = b.dataset.by;
  document.getElementById('q').focus();
});


/* user modal fill (loads history & pendings via inline PHP data source) */
document.addEventListener('click',async (e)=>{
  const b=e.target.closest('[data-modal="user"]'); if(!b) return;
  const uid=b.dataset.uid, phone=b.dataset.phone||'—', steam=b.dataset.steam||'', uname=(b.dataset.uname||'').replace(/^@+/,'') || '—', coin=b.dataset.coin||'0';

  document.getElementById('w-uid').value=uid;
  document.getElementById('w-coin').textContent = new Intl.NumberFormat().format(parseInt(coin,10));

  const steamBlock = steam
    ? `<div class="pill" style="direction:ltr;font-family:monospace">${steam}</div>
       <a target="_blank" href="https://steamcommunity.com/profiles/${steam}" class="btn" style="padding:4px 10px">مشاهده پروفایل استیم</a>`
    : `<div class="pill">استیم: —</div>`;

  document.getElementById('user-info').innerHTML =
    `<div class="pill">کاربر: #${uid}</div>
     <div class="pill">شماره: ${phone||'—'}</div>
     ${steamBlock}
     <div class="pill">@${uname}</div>`;
  // history & pendings via embedded JSON generated by PHP (for simplicity)
  const hist = <?= json_encode(glob(__DIR__.'/orders/*.json')? array_map(function($f){
      $j=@json_decode(@file_get_contents($f),true); $j['_oid']=basename($f,'.json'); return $j?:null;
    }, glob(__DIR__.'/orders/*.json')) : []); ?>;
  const my = (hist||[]).filter(o=>o && String(o.buyer_id||'')===uid);
  const H = my.filter(o=>o.status!=='pending').slice(0,50)
              .map(o=>`<div class="row" style="margin-bottom:6px">
                         <div class="pill ${o.status==='approved'?'b-ok':(o.status==='incomplete'?'b-bad':'b-wait')}">${o.status}</div>
                         <div class="pill">محصول: ${o.product_id||'-'}</div>
                         <div class="pill">سرور: ${o.server||'-'}</div>
                         <div class="pill">قیمت: ${new Intl.NumberFormat().format(parseInt(o.price||0,10))}</div>
                         <div class="pill">تاریخ: ${o.created_at? new Date(o.created_at*1000).toLocaleString('fa-IR'): '—'}</div>
                       </div>`).join('') || '—';
  document.getElementById('hist').innerHTML = H;

  const P = my.filter(o=>o.status==='pending').slice(0,50)
              .map(o=>`<form method="post" class="row" style="align-items:center;margin-bottom:6px">
                        <input type="hidden" name="act" value="order_update">
                        <input type="hidden" name="oid" value="${o._oid}">
                        <div class="pill b-wait">در انتظار</div>
                        <div class="pill">محصول: ${o.product_id||'-'}</div>
                        <div class="pill">قیمت: ${new Intl.NumberFormat().format(parseInt(o.price||0,10))}</div>
                        <button class="btn" name="status" value="approved" type="submit">تایید</button>
                        <button class="btn danger" name="status" value="incomplete" type="submit">ناقص</button>
                       </form>`).join('') || '—';
  document.getElementById('pend').innerHTML = P;

  document.getElementById('modal-user').classList.add('open');
});

/* open from query but default = welcome */
const params=new URLSearchParams(location.search);
const sec=params.get('section');
if(sec==='users') openBox('users');
if(sec==='admins') openBox('admins');

/* auto-hide flash */
setTimeout(()=>{ const f=document.querySelector('.flash'); if(f) f.remove(); }, 4000);
</script>
<script>
// بازکردن مودال آواتار با کلیک روی عکس‌ها
document.addEventListener('click', e=>{
  const img = e.target.closest('.zoomable'); if(!img) return;
  const src = img.dataset.full || img.src;
  document.getElementById('big-avatar').src = src;
  document.getElementById('modal-avatar').classList.add('open');
});
</script>

</body>
</html>
